package com.smartgwt.sample.showcase.client.toolstrip;

import com.smartgwt.client.util.SC;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.menu.Menu;
import com.smartgwt.client.widgets.menu.MenuItem;
import com.smartgwt.client.widgets.toolbar.RibbonBar;
import com.smartgwt.client.widgets.toolbar.RibbonGroup;
import com.smartgwt.client.widgets.RibbonButton;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;


public class RibbonBarSample extends ShowcasePanel {
    private static final String DESCRIPTION = "<p>A RibbonBar is a customized ToolStrip which displays controls in separately titled RibbonGroups.</p>" +
            "<p>The RibbonBar controls the overall presence, placement and text-alignment of each group's title and these can be overridden for individual groups. " +
            "Groups can have multiple rows of controls (group.numRows) and additional columns of rows are automatically added when that number is exceeded. Controls can also span multiple rows (control.rowSpan).</p>" +
            "<p>The example below demonstrates a RibbonBar using it's default RibbonGroup and RibbonButton classes to show various groups with different layouts. You can see groups with horizontal and " +
            "vertical buttons, some of each showing their menuIcons. The 'File' and 'Undo' buttons also have their showMenuIconOver attribute set to true, which causes mouseOver styling on the menuIcon.</p>";

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
            RibbonBarSample panel = new RibbonBarSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    public Canvas getViewPanel() {
        RibbonBar ribbonBar = new RibbonBar();
        ribbonBar.setLeft(0);
        ribbonBar.setTop(75);

        Menu menu = new Menu();
        
        menu.addItem(new MenuItem("Document", "icons/16/document_plain_new.png", "Ctrl+D"));
        menu.addItem(new MenuItem("Picture", "icons/16/folder_out.png", "Ctrl+P"));
        menu.addItem(new MenuItem("Email", "icons/16/disk_blue.png", "Ctrl+E"));

        RibbonGroup fileGroup = new RibbonGroup();
        fileGroup.setTitle("File");
        fileGroup.setTitleAlign(Alignment.LEFT);
        fileGroup.setNumRows(3);
        fileGroup.addControl(getRibbonButton("New", true, menu, "piece_blue", false));  
        fileGroup.addControl(getRibbonButton("Open", true, null, "star_yellow", true));  
        fileGroup.addControl(getRibbonButton("Save", true, null, "pawn_red", true));  
        fileGroup.addControl(getRibbonButton("Save As", true, menu, "cube_green", true));  
  
        RibbonGroup editGroup = new RibbonGroup();  
        editGroup.setTitle("Edit");  
        editGroup.setNumRows(3);  
        editGroup.addControl(getRibbonButton("Edit", false, null, "piece_blue", true));  
        editGroup.addControl(getRibbonButton("Copy", false, null, "pawn_green", true));  
        editGroup.addControl(getRibbonButton("Paste", false, null, "cube_yellow", true));  
        editGroup.addControl(getRibbonButton("Undo", false, menu, null, false));  
        editGroup.addControl(getRibbonButton("Redo", false, menu, null, true));  
  
  
        RibbonGroup insertGroup = new RibbonGroup();  
        insertGroup.setTitle("Insert");  
        insertGroup.setNumRows(3);  
        insertGroup.addControl(getRibbonButton("Picture", true, menu, null, true));  
        insertGroup.addControl(getRibbonButton("Video", true, menu, "piece_red", true));  
        insertGroup.addControl(getRibbonButton("Link", false, null, "pawn_white", true));  
        insertGroup.addControl(getRibbonButton("Document", false, null, "star_yellow", true));  
        
        ribbonBar.addMember(fileGroup);
        ribbonBar.addMember(editGroup);
        ribbonBar.addMember(insertGroup);

        return ribbonBar;

    }

    private RibbonButton getRibbonButton(String title, boolean vertical, Menu menu, String iconName, boolean showMenuIconOver) {
        RibbonButton ribbonButton = new RibbonButton();
        ribbonButton.setTitle(title);
        if (iconName == null) iconName = "cube_blue";
        ribbonButton.setIcon("pieces/16/" + iconName + ".png");
        ribbonButton.setLargeIcon("pieces/48/" + iconName + ".png");
        ribbonButton.setVertical(vertical);
        ribbonButton.setShowMenuIconOver(showMenuIconOver);
    	
        if (menu != null) ribbonButton.setMenu(menu);
    	
        ribbonButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                SC.say(title + " button clicked");
            }
        });
    	
        return ribbonButton;
    }

    public String getIntro() {
        return DESCRIPTION;
    }
    
    public boolean isTopIntro() {
        return true;
    }
}
