
package com.smartgwt.client.docs;

/**
 * <h3>Progressive Loading</h3>
 * The "Progressive Loading" pattern is a way to deal with incrementally retrieving large data
 * sets on demand (see the  <b>Paging and total dataset length</b> section of the {@link
 * com.smartgwt.client.data.ResultSet ResultSet documentation}), when the total  data length is
 * not available. For example - if a row-count database query to retrieve an accurate data count
 * would be prohibitively slow, you may opt to make use of progressive loading instead. <P> In
 * progressive loading mode, the reported {@link com.smartgwt.client.data.DSResponse#getTotalRows
 * DSResponse.totalRows} from a fetch will not be guaranteed to be accurate as long as there are
 * more rows to be fetched beyond the {@link com.smartgwt.client.data.DSRequest#getEndRow
 * requested endRow}. Instead the <code>response.totalRows</code> will be set to the requested
 * endRow plus the configured {@link com.smartgwt.client.docs.serverds.DataSource#endGap
 * DataSource.endGap}. This indicates to the application that more rows are available, and as the
 * user scrolls to access these rows, additional fetch operations will occur to retrieve the extra
 * rows, and will report a new <code>totalRows</code> value. <P> Note that when progressive
 * loading is active, the user will typically not be able to cause direct movement to some
 * arbitrary position in the dataset  (as is the case with ordinary, non-progressive loading). <P>
 * When the user scrolls to the true end of the data-set, the <code>totalRows</code> value is
 * expected to be accurate. <P>
 * @see com.smartgwt.client.data.ResultSet#lengthIsProgressive
 * @see com.smartgwt.client.data.DataSource#getProgressiveLoading
 * @see com.smartgwt.client.docs.serverds.DataSource#progressiveLoadingThreshold
 * @see com.smartgwt.client.docs.serverds.DataSource#lookAhead
 * @see com.smartgwt.client.docs.serverds.DataSource#endGap
 * @see com.smartgwt.client.data.DSRequest#getProgressiveLoading
 * @see com.smartgwt.client.docs.serverds.OperationBinding#progressiveLoading
 * @see com.smartgwt.client.data.ResultSet#getProgressiveLoading
 * @see com.smartgwt.client.data.ResultSet#getRememberDynamicProgressiveLoading
 * @see com.smartgwt.client.widgets.tree.ResultTree#getProgressiveLoading
 * @see com.smartgwt.client.widgets.form.fields.SelectItem#getProgressiveLoading
 * @see com.smartgwt.client.widgets.form.fields.ComboBoxItem#getProgressiveLoading
 */
public interface ProgressiveLoading {
}
