/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql.cachesync;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.cachesync.RequestValuesStrategy;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SQLGetKeysStrategy
extends RequestValuesStrategy {
    private static Logger log = new Logger(SQLGetKeysStrategy.class);

    public boolean worksForBatchAdd(DSRequest request) {
        try {
            DataSource ds = request.getDataSource();
            List keys = ds.getPrimaryKeys();
            for (int i = 0; i < keys.size(); ++i) {
                if (!"sequence".equals(ds.getField((String)keys.get(i)).getType())) continue;
                return false;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error in worksForBatchAdd", (Throwable)e);
        }
        return true;
    }

    public List getCacheSyncData(DSRequest request, DSResponse response) throws Exception {
        boolean hasSequences;
        SQLDataSource ds;
        block18: {
            block17: {
                BasicDataSource bds = (BasicDataSource)request.getDataSource();
                if (!bds.isSQLDataSource()) {
                    throw new Exception("SQLGetKeysStrategy only supports SQLDataSource right now, but was invoked for DS '" + bds.getName() + "', which is an instance of " + bds.getClass().getName());
                }
                ds = (SQLDataSource)request.getDataSource();
                if (SQLDataSource.isUpdate((String)request.getOperationType())) break block17;
                if (!SQLDataSource.isRemove((String)request.getOperationType())) break block18;
            }
            if (response.getAffectedRows() == 0L) {
                return null;
            }
        }
        boolean bl = hasSequences = ds.getSequences() != null && ds.getSequences().keySet().size() > 0;
        if (ds.getSequenceMode() != SQLDataSource.SequenceMode.JDBC_DRIVER && hasSequences) {
            log.info((Object)("SQLGetKeysStrategy has been invoked for DataSource '" + ds.getName() + "', which has a sequenceMode of '" + String.valueOf((Object)ds.getSequenceMode()) + "'. Sequence mode 'jdbcDriver' may give better performance if you are using a JDBC 3.0 or greater driver"));
        }
        boolean cacheSyncFetchAllowed = this.isCacheSyncFetchAllowed(request, response);
        List responseData = null;
        if (SQLDataSource.isRemove((String)request.getOperationType())) {
            responseData = new ArrayList<Map>();
            if (cacheSyncFetchAllowed) {
                responseData.add(request.getLastPrimaryKeys(response));
            }
        } else {
            request.setAttribute("_calledFromGetKeys", (Object)true);
            responseData = super.getCacheSyncData(request, response);
            request.removeAttribute("_calledFromGetKeys");
        }
        if (!cacheSyncFetchAllowed) {
            return responseData;
        }
        if (SQLDataSource.isAdd((String)request.getOperationType())) {
            if (responseData.size() > 1 && !this.worksForBatchAdd(request)) {
                log.warn((Object)"GetKeysStrategy has been invoked for a multi-record add operation, but worksForBatchAdd() returns false for this request. Cache sync data will be incomplete");
            } else {
                Map keys = request.getLastPrimaryKeys(response);
                ((Map)responseData.get(0)).putAll(keys);
            }
        } else if (responseData != null && responseData.size() == request.getCriteriaSets().size()) {
            for (int i = 0; i < responseData.size(); ++i) {
                Map keys = (Map)request.getCriteriaSets().get(i);
                if (keys == null) continue;
                ((Map)responseData.get(i)).putAll(keys);
            }
        }
        this.convertToBeansIfRequired(request, response, responseData);
        return responseData;
    }
}

