/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.Authenticator;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.http.UserRealm;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.B64Code;
import org.openqa.jetty.util.Credential;
import org.openqa.jetty.util.QuotedStringTokenizer;
import org.openqa.jetty.util.StringUtil;
import org.openqa.jetty.util.TypeUtil;

public class DigestAuthenticator
implements Authenticator {
    static Log log = LogFactory.getLog(DigestAuthenticator.class);
    protected long maxNonceAge = 0L;
    protected long nonceSecret = (long)this.hashCode() ^ System.currentTimeMillis();
    protected boolean useStale = false;

    @Override
    public Principal authenticate(UserRealm realm, String pathInContext, HttpRequest request, HttpResponse response) throws IOException {
        boolean stale = false;
        Principal user = null;
        String credentials = request.getField("Authorization");
        if (credentials != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Credentials: " + credentials));
            }
            QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(credentials, "=, ", true, false);
            Digest digest = new Digest(request.getMethod());
            String last = null;
            String name = null;
            block5: while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                char c = tok.length() == 1 ? tok.charAt(0) : (char)'\u0000';
                switch (c) {
                    case '=': {
                        name = last;
                        last = tok;
                        break;
                    }
                    case ',': {
                        name = null;
                    }
                    case ' ': {
                        break;
                    }
                    default: {
                        last = tok;
                        if (name == null) continue block5;
                        if ("username".equalsIgnoreCase(name)) {
                            digest.username = tok;
                            break;
                        }
                        if ("realm".equalsIgnoreCase(name)) {
                            digest.realm = tok;
                            break;
                        }
                        if ("nonce".equalsIgnoreCase(name)) {
                            digest.nonce = tok;
                            break;
                        }
                        if ("nc".equalsIgnoreCase(name)) {
                            digest.nc = tok;
                            break;
                        }
                        if ("cnonce".equalsIgnoreCase(name)) {
                            digest.cnonce = tok;
                            break;
                        }
                        if ("qop".equalsIgnoreCase(name)) {
                            digest.qop = tok;
                            break;
                        }
                        if ("uri".equalsIgnoreCase(name)) {
                            digest.uri = tok;
                            break;
                        }
                        if (!"response".equalsIgnoreCase(name)) continue block5;
                        digest.response = tok;
                    }
                }
            }
            int n = this.checkNonce(digest.nonce, request);
            if (n > 0) {
                user = realm.authenticate(digest.username, digest, request);
            } else if (n == 0) {
                stale = true;
            }
            if (user == null) {
                log.warn((Object)("AUTH FAILURE: user " + digest.username));
            } else {
                request.setAuthType("DIGEST");
                request.setAuthUser(digest.username);
                request.setUserPrincipal(user);
            }
        }
        if (user == null && response != null) {
            this.sendChallenge(realm, request, response, stale);
        }
        return user;
    }

    @Override
    public String getAuthMethod() {
        return "DIGEST";
    }

    public void sendChallenge(UserRealm realm, HttpRequest request, HttpResponse response, boolean stale) throws IOException {
        response.setField("WWW-Authenticate", "Digest realm=\"" + realm.getName() + "\", domain=\"" + response.getHttpContext().getContextPath() + "\", nonce=\"" + this.newNonce(request) + "\", algorithm=MD5, qop=\"auth\"" + (this.useStale ? " stale=" + stale : ""));
        response.sendError(401);
    }

    public String newNonce(HttpRequest request) {
        long ts = request.getTimeStamp();
        long sk = this.nonceSecret;
        byte[] nounce = new byte[24];
        int i = 0;
        while (i < 8) {
            nounce[i] = (byte)(ts & 0xFFL);
            ts >>= 8;
            nounce[8 + i] = (byte)(sk & 0xFFL);
            sk >>= 8;
            ++i;
        }
        byte[] hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(nounce, 0, 16);
            hash = md.digest();
        }
        catch (Exception e) {
            log.fatal((Object)this, (Throwable)e);
        }
        int i2 = 0;
        while (i2 < hash.length) {
            nounce[8 + i2] = hash[i2];
            if (i2 == 23) break;
            ++i2;
        }
        return new String(B64Code.encode(nounce));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int checkNonce(String nonce, HttpRequest request) {
        try {
            byte[] hash;
            long age;
            byte[] n = B64Code.decode(nonce.toCharArray());
            if (n.length != 24) {
                return -1;
            }
            long ts = 0L;
            long sk = this.nonceSecret;
            byte[] n2 = new byte[16];
            int i = 0;
            while (true) {
                if (i >= 8) {
                    age = request.getTimeStamp() - ts;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("age=" + age));
                    }
                    hash = null;
                    try {
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        md.reset();
                        md.update(n2, 0, 16);
                        hash = md.digest();
                    }
                    catch (Exception e) {
                        log.fatal((Object)this, (Throwable)e);
                    }
                    break;
                }
                n2[i] = n[i];
                n2[8 + i] = (byte)(sk & 0xFFL);
                sk >>= 8;
                ts = (ts << 8) + (0xFFL & (long)n[7 - i]);
                ++i;
            }
            int i2 = 0;
            while (true) {
                if (i2 >= 16) {
                    if (this.maxNonceAge <= 0L || age >= 0L && age <= this.maxNonceAge) break;
                    return 0;
                }
                if (n[i2 + 8] != hash[i2]) {
                    return -1;
                }
                ++i2;
            }
            return 1;
        }
        catch (Exception e) {
            log.debug((Object)"", (Throwable)e);
            return -1;
        }
    }

    public long getMaxNonceAge() {
        return this.maxNonceAge;
    }

    public void setMaxNonceAge(long maxNonceAge) {
        this.maxNonceAge = maxNonceAge;
    }

    public long getNonceSecret() {
        return this.nonceSecret;
    }

    public void setNonceSecret(long nonceSecret) {
        this.nonceSecret = nonceSecret;
    }

    public void setUseStale(boolean us) {
        this.useStale = us;
    }

    public boolean getUseStale() {
        return this.useStale;
    }

    private static class Digest
    extends Credential {
        String method = null;
        String username = null;
        String realm = null;
        String nonce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;

        Digest(String m) {
            this.method = m;
        }

        @Override
        public boolean check(Object credentials) {
            String password = credentials instanceof String ? (String)credentials : credentials.toString();
            try {
                byte[] ha1;
                MessageDigest md = MessageDigest.getInstance("MD5");
                if (credentials instanceof Credential.MD5) {
                    ha1 = ((Credential.MD5)credentials).getDigest();
                } else {
                    md.update(this.username.getBytes(StringUtil.__ISO_8859_1));
                    md.update((byte)58);
                    md.update(this.realm.getBytes(StringUtil.__ISO_8859_1));
                    md.update((byte)58);
                    md.update(password.getBytes(StringUtil.__ISO_8859_1));
                    ha1 = md.digest();
                }
                md.reset();
                md.update(this.method.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.uri.getBytes(StringUtil.__ISO_8859_1));
                byte[] ha2 = md.digest();
                md.update(TypeUtil.toString(ha1, 16).getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.nonce.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.nc.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.cnonce.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.qop.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(TypeUtil.toString(ha2, 16).getBytes(StringUtil.__ISO_8859_1));
                byte[] digest = md.digest();
                return TypeUtil.toString(digest, 16).equalsIgnoreCase(this.response);
            }
            catch (Exception e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
                return false;
            }
        }

        public String toString() {
            return String.valueOf(this.username) + "," + this.response;
        }
    }
}

