/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.util.DataTools;

public class SQLExpression
extends Base {
    private static Logger log = new Logger(SQLExpression.class.getName());
    private DSRequest request;
    private IncludeFromDefinition includeFrom;
    private SQLDriver driver;
    private SQLDataSource ds;
    private DSField field;
    private String table;
    private String column;
    private String function;
    private String alias;
    private String expr;
    private String exprFull;
    private String exprFullWithAlias;
    private String exprForSortBy;
    private DSField outputField;
    private String outputType;
    private String subSelectDS;
    private String subSelectOperationId;
    private String subSelectFieldName;
    private boolean isSqlCasted = false;
    private boolean isSubSelect = false;
    private boolean isSQLLimit = false;
    private boolean isCustomSQL = false;
    private boolean isFormula = false;
    private boolean isTemplate = false;
    private boolean isQueryField = false;
    private Exception constructorEx;
    private boolean excluded = false;
    private boolean excludedFromWhereClause = false;
    private String reasonForExcluding;

    protected SQLExpression(DSRequest request, SQLDriver driver, SQLDataSource ds, DSField field) {
        this.request = request;
        this.driver = driver;
        this.ds = ds;
        this.field = field;
        this.constructorEx = new Exception();
    }

    protected String creationStack() {
        return DataTools.getStackTrace((Throwable)this.constructorEx, (int)10);
    }

    protected String creationStack(int depth) {
        return DataTools.getStackTrace((Throwable)this.constructorEx, (int)depth);
    }

    public String getExprFull() {
        return this.exprFull != null ? this.exprFull : this.expr;
    }

    public SQLExpression setExprFull(String exprFull) {
        this.exprFull = exprFull;
        return this;
    }

    public String getExprFullWithAlias() {
        return this.exprFullWithAlias != null ? this.exprFullWithAlias : this.expr;
    }

    public SQLExpression setExprFullWithAlias(String exprFullWithAlias) {
        this.exprFullWithAlias = exprFullWithAlias;
        return this;
    }

    public String getExprForSortBy() {
        return this.exprForSortBy != null ? this.exprForSortBy : this.expr;
    }

    public SQLExpression setExprForSortBy(String exprForSortBy) {
        this.exprForSortBy = exprForSortBy;
        return this;
    }

    public DSField getOutputField() {
        return this.outputField;
    }

    public SQLExpression setOutputField(DSField outputField) {
        this.outputField = outputField;
        return this;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public SQLExpression setOutputType(String outputType) {
        this.outputType = outputType;
        return this;
    }

    public DSRequest getRequest() {
        return this.request;
    }

    public SQLExpression setRequest(DSRequest request) {
        this.request = request;
        return this;
    }

    public IncludeFromDefinition getIncludeFrom() {
        return this.includeFrom;
    }

    public SQLExpression setIncludeFrom(IncludeFromDefinition includeFrom) {
        this.includeFrom = includeFrom;
        return this;
    }

    public SQLDriver getDriver() {
        return this.driver;
    }

    public SQLExpression setDriver(SQLDriver driver) {
        this.driver = driver;
        return this;
    }

    public SQLDataSource getDs() {
        return this.ds;
    }

    public SQLExpression setDs(SQLDataSource ds) {
        this.ds = ds;
        return this;
    }

    public DSField getField() {
        return this.field;
    }

    public SQLExpression setField(DSField field) {
        this.field = field;
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public SQLExpression setTable(String table) {
        this.table = table;
        return this;
    }

    public String getColumn() {
        return this.column;
    }

    public SQLExpression setColumn(String column) {
        this.column = column;
        return this;
    }

    public String getExpr() {
        return this.expr;
    }

    public SQLExpression setExpr(String expr) {
        this.expr = expr;
        return this;
    }

    public String getSubSelectDS() {
        return this.subSelectDS;
    }

    public SQLExpression setSubSelectDS(String subSelectDS) {
        this.subSelectDS = subSelectDS;
        return this;
    }

    public String getSubSelectOperationId() {
        return this.subSelectOperationId;
    }

    public SQLExpression setSubSelectOperationId(String subSelectOperationId) {
        this.subSelectOperationId = subSelectOperationId;
        return this;
    }

    public String getSubSelectFieldName() {
        return this.subSelectFieldName;
    }

    public SQLExpression setSubSelectFieldName(String subSelectFieldName) {
        this.subSelectFieldName = subSelectFieldName;
        return this;
    }

    public String getFunction() {
        return this.function;
    }

    public SQLExpression setFunction(String function) {
        this.function = function;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public SQLExpression setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public boolean isAggregation() {
        return this.function != null;
    }

    public boolean isSqlCasted() {
        return this.isSqlCasted;
    }

    public SQLExpression setSqlCasted() {
        this.isSqlCasted = true;
        return this;
    }

    public boolean isIncludeFrom() {
        return this.includeFrom != null;
    }

    public boolean isSubSelect() {
        return this.isSubSelect;
    }

    public SQLExpression setSubSelect() {
        this.isSubSelect = true;
        return this;
    }

    public boolean isSQLLimit() {
        return this.isSQLLimit;
    }

    public SQLExpression setSQLLimit() {
        this.isSQLLimit = true;
        return this;
    }

    public boolean isCustomSQL() {
        return this.isCustomSQL;
    }

    public SQLExpression setCustomSQL() {
        this.isCustomSQL = true;
        return this;
    }

    public boolean isFormula() {
        return this.isFormula;
    }

    public SQLExpression setFormula() {
        this.isFormula = true;
        return this;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public SQLExpression setTemplate() {
        this.isTemplate = true;
        return this;
    }

    public boolean isQueryField() {
        return this.isQueryField;
    }

    public SQLExpression setQueryField() {
        this.isQueryField = true;
        return this;
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public SQLExpression setExcluded(boolean excluded) {
        this.excluded = excluded;
        return this;
    }

    public boolean isExcludedFromWhereClause() {
        return this.excludedFromWhereClause;
    }

    public SQLExpression setExcludedFromWhereClause(boolean excluded) {
        this.excludedFromWhereClause = excluded;
        return this;
    }

    public String getReasonForExcluding() {
        return this.reasonForExcluding;
    }

    public SQLExpression setReasonForExcluding(String reasonForExcluding) {
        this.reasonForExcluding = reasonForExcluding;
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SQLExpression{");
        sb.append("request=").append(this.request.hashCode());
        sb.append(", \r\nexcluded=").append(this.excluded);
        if (this.excluded) {
            sb.append(", \r\nreasonForExcluding=").append(this.reasonForExcluding);
        }
        sb.append(", \r\nexcludedFromWhereClause=").append(this.excludedFromWhereClause);
        sb.append(", \r\nincludeFrom=").append(this.includeFrom != null ? this.includeFrom.getThisDataSource().getName() + "." + this.includeFrom.getThisFieldName() : null);
        sb.append(", \r\ndriver=").append(((Object)((Object)this.driver)).getClass().getName());
        sb.append(", \r\nds=").append(this.ds.getName());
        sb.append(", \r\nfield=").append(this.field != null ? this.field.getName() : null);
        sb.append(", \r\ntable=").append(this.table);
        sb.append(", \r\ncolumn=").append(this.column);
        sb.append(", \r\nfunction=").append(this.function);
        sb.append(", \r\nalias=").append(this.alias);
        sb.append(", \r\nexpr=").append(this.expr);
        sb.append(", \r\nexprFull=").append(this.exprFull);
        sb.append(", \r\nexprFullWithAlias=").append(this.exprFullWithAlias);
        sb.append(", \r\nexprForSortBy=").append(this.exprForSortBy);
        sb.append(", \r\noutputType=").append(this.outputField != null ? this.outputField.getName() : null);
        sb.append(", \r\noutputType=").append(this.outputType);
        sb.append(", \r\nsubSelectDS=").append(this.subSelectDS);
        sb.append(", \r\nsubSelectOperationId=").append(this.subSelectOperationId);
        sb.append(", \r\nsubSelectFieldName=").append(this.subSelectFieldName);
        sb.append(", \r\nisSqlCasted=").append(this.isSqlCasted);
        sb.append(", \r\nisSubSelect=").append(this.isSubSelect);
        sb.append(", \r\nisSQLLimit=").append(this.isSQLLimit);
        sb.append(", \r\nisCustomSQL=").append(this.isCustomSQL);
        sb.append(", \r\nisFormula=").append(this.isFormula);
        sb.append(", \r\nisTemplate=").append(this.isTemplate);
        sb.append(", \r\nisQueryField=").append(this.isQueryField);
        sb.append('}');
        return sb.toString();
    }
}

