/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.io;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.io.file.ISCClassPathFile;
import com.isomorphic.io.file.ISCContainerFile;
import com.isomorphic.io.file.ISCFileSourceFile;
import com.isomorphic.io.file.ISCNativeFile;
import com.isomorphic.io.file.ISCUrlFile;
import com.isomorphic.io.file.ISCVfsFile;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;

public abstract class ISCFile {
    private static Logger log = new Logger(ISCFile.class.getName());
    public static final String SHUTDOWN = "; shutdown=true";
    public static ServletContext servletContext = null;
    protected static String fallBackRootDir;
    protected String filename;
    protected DSRequest requestContext;
    protected ISCFile delegate;
    public static final String CONTAINER_IO_PREFIX = "__USE_CONTAINER__";
    private static final String INVALID_CHARS = "<>:\"/\\|?*";
    private static final String[] RESERVED_WINDOWS_NAMES;

    public static ISCFile newInstance(String filename, DSRequest request) throws IOException {
        if (((String)filename).startsWith("{CLASSPATH}")) {
            return new ISCClassPathFile((String)filename, request);
        }
        if (((String)filename).startsWith("ds:/")) {
            return new ISCFileSourceFile((String)filename, request);
        }
        if (((String)filename).startsWith("ram://") || ((String)filename).startsWith("res://")) {
            return new ISCVfsFile((String)filename, request);
        }
        if (ISCFile.isContainerIOPath((String)filename)) {
            filename = ISCFile.canonicalizePath((String)filename);
            if (servletContext == null) {
                if (fallBackRootDir != null) {
                    if (!((String)(filename = ISCFile.stripContainerIOPrefix((String)filename))).startsWith("/")) {
                        filename = "/" + (String)filename;
                    }
                    return new ISCNativeFile(ISCFile.canonicalizePath(fallBackRootDir + "/" + (String)filename), request);
                }
                throw new IOException("Configured for containerIO, but servletContext not available!  You need to install the Init servlet.  Or, to use DataSources in a standalone app, manually edit server.properties to set webRoot to your app's root folder.  See help topic standaloneDataSourceUsage.");
            }
            return new ISCContainerFile((String)filename, request);
        }
        if (((String)filename).startsWith("file:")) {
            filename = ((String)filename).substring("file:".length());
        }
        if (DataTools.isURI((String)filename)) {
            return new ISCUrlFile((String)filename, request);
        }
        return new ISCNativeFile((String)filename, request);
    }

    public static ISCFile newInstance(String filename) throws IOException {
        return ISCFile.newInstance(filename, null);
    }

    public static ISCFile newInstance(URL url, DSRequest request) {
        return new ISCUrlFile(url, request);
    }

    public static ISCFile newInstance(URL url) {
        return ISCFile.newInstance(url, null);
    }

    public static ISCFile newInstance(File file, DSRequest request) {
        return new ISCNativeFile(file, request);
    }

    public static ISCFile newInstance(File file) {
        return ISCFile.newInstance(file, null);
    }

    public static ISCFile newInstance(FileObject fileObject, DSRequest request) {
        return new ISCVfsFile(fileObject, request);
    }

    public static ISCFile newInstance(FileObject fileObject) {
        return ISCFile.newInstance(fileObject, null);
    }

    public static ISCFile newInstance(DSFileSpec fileSpec, DSRequest request) {
        return new ISCFileSourceFile(fileSpec, request);
    }

    public static ISCFile newInstance(DSFileSpec fileSpec) {
        return ISCFile.newInstance(fileSpec, null);
    }

    public DSRequest getRequestContext() {
        return this.requestContext;
    }

    protected ISCFile(String filename, DSRequest request) {
        this.requestContext = request;
        this.filename = filename;
    }

    public boolean delete() throws IOException {
        if (this.delegate != null) {
            return this.delegate.delete();
        }
        throw new IOException("delete() operation not supported for path: " + this.getCanonicalPath());
    }

    public boolean exists() throws IOException {
        if (this.delegate != null) {
            return this.delegate.exists();
        }
        throw new IllegalStateException("exists() not supported for path: " + this.getCanonicalPath());
    }

    public String getParent() {
        if (this.delegate != null) {
            return this.delegate.getParent();
        }
        return new File(this.filename).getParent();
    }

    public String getCanonicalPath() throws IOException {
        if (this.delegate != null) {
            return this.delegate.getCanonicalPath();
        }
        return this.filename;
    }

    public boolean canRead() throws IOException {
        if (this.delegate != null) {
            return this.delegate.canRead();
        }
        return false;
    }

    public boolean canWrite() throws IOException {
        if (this.delegate != null) {
            return this.delegate.canWrite();
        }
        return false;
    }

    public boolean mkdir() throws IOException {
        if (this.delegate != null) {
            return this.delegate.mkdir();
        }
        throw new IOException("mkdir() not supported for path: " + this.getCanonicalPath());
    }

    public boolean mkdirs() throws IOException {
        if (this.delegate != null) {
            return this.delegate.mkdirs();
        }
        throw new IOException("mkdirs() not supported for path: " + this.getCanonicalPath());
    }

    public String getPath() throws IOException {
        if (this.delegate != null) {
            return this.delegate.getPath();
        }
        return this.getCanonicalPath();
    }

    public String getName() throws IOException {
        if (this.delegate != null) {
            return this.delegate.getName();
        }
        String name = ISCFile.canonicalizePath(this.getPath());
        int slashIndex = name.lastIndexOf("/");
        if (slashIndex != -1) {
            name = name.substring(slashIndex + 1);
        }
        return name;
    }

    public Object getNativeHandler() {
        if (this.delegate != null) {
            return this.delegate.getNativeHandler();
        }
        return null;
    }

    public Reader getReader() throws IOException {
        if (this.delegate != null) {
            return this.delegate.getReader();
        }
        return this.getReader(null);
    }

    public Reader getReader(Charset charset) throws IOException {
        if (this.delegate != null) {
            return this.delegate.getReader(charset);
        }
        InputStream is = this.getInputStream();
        if (charset == null) {
            return new InputStreamReader(is);
        }
        return new InputStreamReader(is, charset);
    }

    public String getAsString() throws IOException {
        if (this.delegate != null) {
            return this.delegate.getAsString();
        }
        StringWriter sw = new StringWriter();
        Reader reader = this.getReader();
        IOUtil.copyCharacterStreams(reader, sw);
        reader.close();
        return sw.toString();
    }

    public ISCFile write(String s) throws IOException {
        Writer writer = this.getWriter();
        writer.write(s);
        writer.close();
        return this;
    }

    public InputStream getInputStream() throws IOException {
        if (this.delegate != null) {
            return this.delegate.getInputStream();
        }
        throw new IOException("getInputStream() not supported for path: " + this.getCanonicalPath());
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.delegate != null) {
            return this.delegate.getOutputStream();
        }
        throw new IOException("getOutputStream() not supported for path: " + this.getCanonicalPath());
    }

    public Writer getWriter() throws IOException {
        if (this.delegate != null) {
            return this.delegate.getWriter();
        }
        return new OutputStreamWriter(this.getOutputStream());
    }

    public boolean isURL() {
        if (this.delegate != null) {
            return this.delegate.isURL();
        }
        return false;
    }

    public boolean isJarURL() {
        if (this.delegate != null) {
            return this.delegate.isJarURL();
        }
        return false;
    }

    public long length() throws IOException {
        if (this.delegate != null) {
            return this.delegate.length();
        }
        return -1L;
    }

    public long lastModified() throws IOException {
        if (this.delegate != null) {
            return this.delegate.lastModified();
        }
        return 0L;
    }

    public boolean setLastModified(long time) throws IOException {
        if (this.delegate != null) {
            return this.delegate.setLastModified(time);
        }
        return false;
    }

    public boolean isDirectory() throws IOException {
        if (this.delegate != null) {
            return this.delegate.isDirectory();
        }
        return this.filename.endsWith("/");
    }

    public boolean renameTo(ISCFile destination) throws IOException {
        if (this.delegate != null) {
            return this.delegate.renameTo(destination);
        }
        throw new IllegalStateException("renameTo() not supported (" + this.getCanonicalPath() + " -> " + destination.getCanonicalPath());
    }

    public Map<String, Object> readAttributes() throws Exception {
        if (this.delegate != null) {
            return this.delegate.readAttributes();
        }
        String name = this.getName();
        Map<String, Object> result = ISCFile.parseFileExtensions(name);
        result.put("fileSize", this.length());
        result.put("fileLastModified", this.lastModified());
        return result;
    }

    public List<Map<String, Object>> findChildAttributes(Object criteria, DSRequest request) throws Exception {
        if (this.delegate != null) {
            return this.delegate.findChildAttributes(criteria, request);
        }
        List<ISCFile> children = this.findChildren(criteria, request);
        ArrayList<Map<String, Object>> attributes = new ArrayList<Map<String, Object>>(children.size());
        for (ISCFile child : children) {
            attributes.add(child.readAttributes());
        }
        return attributes;
    }

    public List<ISCFile> findChildren(Object criteria, DSRequest request) throws Exception {
        if (this.delegate != null) {
            return this.delegate.findChildren(criteria, request);
        }
        return new ArrayList<ISCFile>(0);
    }

    public ISCFile getChild(Map<String, Object> primaryKeys, DSRequest request) throws IOException {
        if (this.delegate != null) {
            return this.delegate.getChild(primaryKeys, request);
        }
        throw new IllegalStateException("getChild() not supported for path: " + this.getCanonicalPath());
    }

    public ISCFile getChild(String path, DSRequest request) throws IOException {
        if (this.delegate != null) {
            return this.delegate.getChild(path, request);
        }
        throw new IllegalStateException("getChild() not supported for path: " + this.getCanonicalPath());
    }

    public static Map<String, Object> parseFileExtensions(String name) {
        String fileName = null;
        String fileType = null;
        String fileFormat = null;
        String[] tokens = StringUtils.split((String)name, (char)'.');
        int length = tokens.length;
        switch (length) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (tokens[1].contains(" ") || tokens[1].contains("/")) break;
                fileType = tokens[1];
                break;
            }
            default: {
                fileType = tokens[length - 2];
                fileFormat = tokens[length - 1];
                if (fileFormat.contains(" ") || fileFormat.contains("/")) {
                    fileType = null;
                    fileFormat = null;
                    break;
                }
                if (!fileType.contains(" ") && !fileType.contains("/")) break;
                fileType = fileFormat;
                fileFormat = null;
            }
        }
        fileName = name;
        if (fileFormat != null) {
            fileName = StringUtils.removeEnd((String)fileName, (String)("." + fileFormat));
        }
        if (fileType != null) {
            fileName = StringUtils.removeEnd((String)fileName, (String)("." + fileType));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("fileName", fileName);
        if (fileFormat != null) {
            result.put("fileFormat", fileFormat);
        }
        if (fileType != null) {
            result.put("fileType", fileType);
        }
        return result;
    }

    public static String expandFileExtensions(Map<String, Object> values) {
        Object fileFormat;
        Object fileType;
        StringBuilder sb = new StringBuilder();
        Object fileName = values.get("fileName");
        if (fileName != null) {
            sb.append(fileName);
        }
        if ((fileType = values.get("fileType")) != null) {
            sb.append('.');
            sb.append(fileType);
        }
        if ((fileFormat = values.get("fileFormat")) != null) {
            sb.append('.');
            sb.append(fileFormat);
        }
        return sb.toString();
    }

    public static boolean isContainerIOPath(String path) {
        Config config = Config.getGlobal(false);
        if (config == null) {
            return false;
        }
        List<String> prefixes = config.getCommaSeparatedList("containerIOPrefixes");
        if (prefixes == null) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String stripContainerIOPrefix(String path) {
        Config config = Config.getGlobal();
        if (config == null) {
            return path;
        }
        List<String> prefixes = config.getCommaSeparatedList("containerIOPrefixes");
        if (prefixes == null) {
            return path;
        }
        for (String prefix : prefixes) {
            int containerIOIndex = path.indexOf(prefix);
            if (containerIOIndex != 0) continue;
            path = path.substring(containerIOIndex + prefix.length());
            break;
        }
        return path;
    }

    public static String canonicalizePath(String path) {
        return ISCFile.canonicalizePath(path, true);
    }

    public static String canonicalizePath(String path, boolean trimTrailingSlash) {
        char lastChar;
        if (path == null) {
            return null;
        }
        path = path.trim();
        StringWriter sw = new StringWriter();
        int copiedFrom = 0;
        int length = path.length();
        for (int ii = 0; ii < length; ++ii) {
            char nextChar;
            char currChar = path.charAt(ii);
            if (currChar != '\\' && currChar != '/') continue;
            sw.write(path.substring(copiedFrom, ii));
            sw.write(47);
            while (ii + 1 < length && ((nextChar = path.charAt(ii + 1)) == '/' || nextChar == '\\')) {
                if (ii - 1 >= 0 && path.charAt(ii - 1) == ':') {
                    sw.write(47);
                }
                ++ii;
            }
            copiedFrom = ii + 1;
        }
        sw.write(path.substring(copiedFrom, length));
        path = sw.getBuffer().toString();
        length = path.length();
        if (length > 1 && trimTrailingSlash && ((lastChar = path.charAt(length - 1)) == '/' || lastChar == '\\')) {
            path = path.substring(0, length - 1);
        }
        return path;
    }

    public static boolean isSafeFilename(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) >= ' ') continue;
            return false;
        }
        for (char c : INVALID_CHARS.toCharArray()) {
            if (name.indexOf(c) < 0) continue;
            return false;
        }
        if (name.endsWith(" ") || name.endsWith(".")) {
            return false;
        }
        String baseName = name.contains(".") ? name.substring(0, name.indexOf(46)) : name;
        String upper = baseName.toUpperCase(Locale.ROOT);
        for (String reserved : RESERVED_WINDOWS_NAMES) {
            if (!upper.equals(reserved)) continue;
            return false;
        }
        return true;
    }

    public static boolean inContainerIOMode() {
        Config config = Config.getGlobal();
        return ISCFile.isContainerIOPath(config.getPath("webRoot"));
    }

    public static List<String> list(String path) {
        if (servletContext != null) {
            Set files = servletContext.getResourcePaths(ISCFile.stripContainerIOPrefix(path));
            if (files == null) {
                return null;
            }
            return new ArrayList<String>(files);
        }
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        String[] files = f.list();
        if (files == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String file : files) {
            String fileName = ISCFile.canonicalizePath(path + "/" + file);
            File x = new File(fileName);
            if (x.isDirectory()) {
                results.add(fileName + "/");
                continue;
            }
            results.add(fileName);
        }
        return results;
    }

    public static List<String> list(String path, String regex) {
        return ISCFile.list(path, Pattern.compile(regex));
    }

    public static List<String> list(String path, Pattern pattern) {
        Set files = servletContext.getResourcePaths(ISCFile.stripContainerIOPrefix(path));
        if (files == null) {
            return null;
        }
        ArrayList<String> matchingFiles = new ArrayList<String>();
        for (String file : files) {
            if (!pattern.matcher(file).find()) continue;
            matchingFiles.add(file);
        }
        return matchingFiles;
    }

    public static List<String> find(String basePath, boolean recurse, String glob) {
        if (basePath == null) {
            return null;
        }
        List<String> filesAtBasePath = ISCFile.list(basePath);
        if (filesAtBasePath == null) {
            return null;
        }
        ArrayList<String> matchingFiles = new ArrayList<String>();
        for (String path : filesAtBasePath) {
            String file;
            List<String> matchingFilesInDir;
            if (recurse && ISCFile.isDirectory(path) && (matchingFilesInDir = ISCFile.find(path, true, glob)) != null) {
                matchingFiles.addAll(matchingFilesInDir);
            }
            if ((file = path.substring(basePath.length())).startsWith("/")) {
                file = file.substring(1);
            }
            boolean fileMatchesGlob = false;
            fileMatchesGlob = FileSystems.getDefault().getPathMatcher("glob:" + glob).matches(Paths.get(file, new String[0]));
            if (!fileMatchesGlob) continue;
            matchingFiles.add(path);
        }
        return matchingFiles;
    }

    public static List<String> ffind(String basePath, boolean recurse, String regex) {
        return ISCFile.ffind(basePath, recurse, Pattern.compile(regex));
    }

    public static List<String> ffind(String basePath, boolean recurse, Pattern pattern) {
        if (basePath == null) {
            return null;
        }
        List<String> filesAtBasePath = ISCFile.list(basePath);
        if (filesAtBasePath == null) {
            return null;
        }
        ArrayList<String> matchingFiles = new ArrayList<String>();
        for (String path : filesAtBasePath) {
            List<String> matchingFilesInDir;
            if (recurse && ISCFile.isDirectory(path) && (matchingFilesInDir = ISCFile.ffind(path, true, pattern)) != null) {
                matchingFiles.addAll(matchingFilesInDir);
            }
            if (!pattern.matcher(path).find()) continue;
            matchingFiles.add(path);
        }
        return matchingFiles;
    }

    public static boolean isDirectory(String path) {
        return path.endsWith("/");
    }

    public static void setFallBackRootDir(String fallBackRootDir) {
        ISCFile.fallBackRootDir = fallBackRootDir;
    }

    public static boolean isUnresolvedContainer(String path) {
        return path.contains(CONTAINER_IO_PREFIX);
    }

    public static String replaceUnresolvedContainer(String path) {
        if (fallBackRootDir == null) {
            return path;
        }
        return path.replaceFirst(CONTAINER_IO_PREFIX, fallBackRootDir);
    }

    public static File getCanonicalFile(String filename) throws IOException {
        return (File)new ISCNativeFile(filename).getNativeHandler();
    }

    public static InputStream getCanonicalInputStream(String filename) throws IOException {
        ISCFile file = servletContext != null ? new ISCContainerFile(filename) : new ISCNativeFile(filename);
        return file != null ? file.getInputStream() : null;
    }

    static {
        RESERVED_WINDOWS_NAMES = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    }
}

