/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.tools.DataExport;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class DatabaseExportServlet
extends BaseServlet {
    private static Logger log = new Logger(DatabaseExportServlet.class.getName());
    protected static JSTranslater jsTrans = new JSTranslater();

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            RequestContext context = RequestContext.instance((Servlet)this, (HttpServletRequest)request, (HttpServletResponse)response);
            if (!this.authorizeRequest(context)) {
                throw new Exception("Access denied.");
            }
            String datasource = request.getParameter("datasource");
            String table = request.getParameter("table");
            boolean JSLiteral = request.getParameter("jsliteral") != null;
            String columns = request.getParameter("columns");
            String columnOrder = request.getParameter("columnOrder");
            if (datasource == null && table == null) {
                throw new Exception("Must provide a source (datasource or table name).");
            }
            if (datasource != null && table != null) {
                throw new Exception("Must provide only one source (datasource or table name).");
            }
            String source = datasource;
            if (datasource == null) {
                source = table;
            }
            response.setStatus(200);
            if (JSLiteral) {
                context.setContentType("text/plain");
            } else {
                context.setContentType("application/csv");
            }
            DataExport.processDataExportRequest(table != null ? 2 : 1, JSLiteral ? 2 : 1, source, columns, columnOrder, context.out());
            context.completeResponse();
        }
        catch (Exception e) {
            ServletTools.sendFormattedError((HttpServletResponse)response, (Exception)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected boolean authorizeRequest(RequestContext context) throws Exception {
        return true;
    }
}

