/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PessimisticLockException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PgJdbcHelper;
import org.hibernate.dialect.PostgreSQLCastingInetJdbcType;
import org.hibernate.dialect.PostgreSQLCastingIntervalSecondJdbcType;
import org.hibernate.dialect.PostgreSQLCastingJsonJdbcType;
import org.hibernate.dialect.PostgreSQLDriverKind;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;
import org.hibernate.dialect.PostgreSQLOrdinalEnumJdbcType;
import org.hibernate.dialect.PostgreSQLSqlAstTranslator;
import org.hibernate.dialect.PostgreSQLStructCastingJdbcType;
import org.hibernate.dialect.PostgreSQLUUIDJdbcType;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.PostgreSQLAggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.PostgreSQLMinMaxFunction;
import org.hibernate.dialect.function.PostgreSQLTruncFunction;
import org.hibernate.dialect.function.PostgreSQLTruncRoundFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.PostgreSQLIdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.PostgreSQLSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.unique.CreateTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.procedure.internal.PostgreSQLCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.SemanticException;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.mutation.internal.cte.CteInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.jdbc.OptionalTableUpdateOperation;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsBinaryTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.XmlJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.ArrayDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NamedNativeEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NamedNativeOrdinalEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.Scale6IntervalSecondDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLDialect
extends Dialect {
    protected static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(12);
    private final UniqueDelegate uniqueDelegate = new CreateTableUniqueDelegate(this);
    protected final PostgreSQLDriverKind driverKind;
    private final OptionalTableUpdateStrategy optionalTableUpdateStrategy;
    private final ParameterMarkerStrategy parameterRenderer;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String sqlState = JdbcExceptionHelper.extractSqlState(sqle);
        if (sqlState != null) {
            switch (Integer.parseInt(sqlState)) {
                case 23514: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("violates check constraint \"", "\"", sqle.getMessage());
                }
                case 23505: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("violates unique constraint \"", "\"", sqle.getMessage());
                }
                case 23503: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("violates foreign key constraint \"", "\"", sqle.getMessage());
                }
                case 23502: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("null value in column \"", "\" violates not-null constraint", sqle.getMessage());
                }
                case 23001: {
                    return null;
                }
            }
        }
        return null;
    });

    public PostgreSQLDialect() {
        this(MINIMUM_VERSION);
    }

    public PostgreSQLDialect(DialectResolutionInfo info) {
        this(info.makeCopyOrDefault(MINIMUM_VERSION), PostgreSQLDriverKind.determineKind(info));
        this.registerKeywords(info);
    }

    public PostgreSQLDialect(DatabaseVersion version) {
        this(version, PostgreSQLDriverKind.PG_JDBC);
    }

    public PostgreSQLDialect(DatabaseVersion version, PostgreSQLDriverKind driverKind) {
        super(version);
        this.driverKind = driverKind;
        this.optionalTableUpdateStrategy = PostgreSQLDialect.determineOptionalTableUpdateStrategy(version);
        this.parameterRenderer = driverKind == PostgreSQLDriverKind.VERT_X ? NativeParameterMarkers.INSTANCE : super.getNativeParameterMarkerStrategy();
    }

    private static OptionalTableUpdateStrategy determineOptionalTableUpdateStrategy(DatabaseVersion version) {
        return version.isSameOrAfter(DatabaseVersion.make(15, 0)) ? PostgreSQLDialect::usingMerge : PostgreSQLDialect::withoutMerge;
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    public boolean getDefaultNonContextualLobCreation() {
        return true;
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: {
                return "smallint";
            }
            case -15: {
                return this.columnType(1);
            }
            case -9: {
                return this.columnType(12);
            }
            case 4001: 
            case 4002: {
                return "text";
            }
            case 2004: 
            case 2005: 
            case 2011: {
                return "oid";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "bytea";
            }
            case 3003: {
                return this.columnType(2014);
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected String castType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 4001: 
            case 4002: {
                return "text";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "bytea";
            }
        }
        return super.castType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new ArrayDdlTypeImpl(this, true));
        ddlTypeRegistry.addDescriptor(CapacityDependentDdlType.builder(6, this.columnType(6), this.castType(6), (Dialect)this).withTypeCapacity(24L, "float4").build());
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(2009, "xml", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3000, "uuid", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3002, "inet", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3200, "geometry", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3250, "geography", this));
        ddlTypeRegistry.addDescriptor(new Scale6IntervalSecondDdlType(this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "jsonb", this));
        ddlTypeRegistry.addDescriptor(new NamedNativeEnumDdlTypeImpl(this));
        ddlTypeRegistry.addDescriptor(new NamedNativeOrdinalEnumDdlTypeImpl(this));
    }

    @Override
    public int getMaxVarcharLength() {
        return 0xA00000;
    }

    @Override
    public int getMaxVarcharCapacity() {
        return 0x40000000;
    }

    @Override
    public int getMaxVarbinaryLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 15;
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 1111: {
                switch (columnTypeName) {
                    case "uuid": {
                        jdbcTypeCode = 3000;
                        break;
                    }
                    case "json": 
                    case "jsonb": {
                        jdbcTypeCode = 3001;
                        break;
                    }
                    case "xml": {
                        jdbcTypeCode = 2009;
                        break;
                    }
                    case "inet": {
                        jdbcTypeCode = 3002;
                        break;
                    }
                    case "geometry": {
                        jdbcTypeCode = 3200;
                        break;
                    }
                    case "geography": {
                        jdbcTypeCode = 3250;
                    }
                }
                break;
            }
            case 92: {
                if (!"timetz".equals(columnTypeName)) break;
                jdbcTypeCode = 3007;
                break;
            }
            case 93: {
                if (!"timestamptz".equals(columnTypeName)) break;
                jdbcTypeCode = 3003;
                break;
            }
            case 2003: {
                String componentTypeName;
                Integer sqlTypeCode;
                if (columnTypeName.charAt(0) != '_' || (sqlTypeCode = this.resolveSqlTypeCode(componentTypeName = columnTypeName.substring(1), jdbcTypeRegistry.getTypeConfiguration())) == null) break;
                return jdbcTypeRegistry.resolveTypeConstructorDescriptor(jdbcTypeCode, jdbcTypeRegistry.getDescriptor(sqlTypeCode), ColumnTypeInformation.EMPTY);
            }
            case 2002: {
                AggregateJdbcType aggregateDescriptor = jdbcTypeRegistry.findAggregateDescriptor(columnTypeName);
                if (aggregateDescriptor == null) break;
                return aggregateDescriptor;
            }
        }
        return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
    }

    @Override
    protected Integer resolveSqlTypeCode(String columnTypeName, TypeConfiguration typeConfiguration) {
        switch (columnTypeName) {
            case "bool": {
                return 16;
            }
            case "float4": {
                return 7;
            }
            case "float8": {
                return 8;
            }
            case "int2": {
                return 5;
            }
            case "int4": {
                return 4;
            }
            case "int8": {
                return -5;
            }
        }
        return super.resolveSqlTypeCode(columnTypeName, typeConfiguration);
    }

    @Override
    public String getEnumTypeDeclaration(String name, String[] values) {
        return name;
    }

    @Override
    public String[] getCreateEnumTypeCommand(String name, String[] values) {
        StringBuilder type = new StringBuilder();
        type.append("create type ").append(name).append(" as enum (");
        String separator = "";
        for (String value : values) {
            type.append(separator).append('\'').append(value).append('\'');
            separator = ",";
        }
        type.append(')');
        String cast1 = "create cast (varchar as " + name + ") with inout as implicit";
        String cast2 = "create cast (" + name + " as varchar) with inout as implicit";
        return new String[]{type.toString(), cast1, cast2};
    }

    @Override
    public String[] getDropEnumTypeCommand(String name) {
        return new String[]{"drop type if exists " + name + " cascade"};
    }

    @Override
    public String currentTime() {
        return "localtime";
    }

    @Override
    public String currentTimestamp() {
        return "localtimestamp";
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "(" + super.extractPattern(unit) + "+1)";
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return intervalType != null ? "(?2+?3)" : "cast(?3+" + PostgreSQLDialect.intervalPattern(unit) + " as " + temporalType.name().toLowerCase() + ")";
    }

    private static String intervalPattern(TemporalUnit unit) {
        switch (unit) {
            case NANOSECOND: {
                return "(?2)/1e3*interval '1 microsecond'";
            }
            case NATIVE: {
                return "(?2)*interval '1 second'";
            }
            case QUARTER: {
                return "(?2)*interval '3 month'";
            }
            case WEEK: {
                return "(?2)*interval '7 day'";
            }
        }
        return "(?2)*interval '1 " + unit + "'";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == null) {
            return "(?3-?2)";
        }
        if (toTemporalType == TemporalType.DATE && fromTemporalType == TemporalType.DATE) {
            switch (unit) {
                case QUARTER: 
                case YEAR: 
                case MONTH: {
                    return "extract(" + this.translateDurationField(unit) + " from age(?3,?2))";
                }
            }
            return "(?3-?2)" + TemporalUnit.DAY.conversionFactor(unit, this);
        }
        switch (unit) {
            case YEAR: {
                return "extract(year from ?3-?2)";
            }
            case QUARTER: {
                return "(extract(year from ?3-?2)*4+extract(month from ?3-?2)/3)";
            }
            case MONTH: {
                return "(extract(year from ?3-?2)*12+extract(month from ?3-?2))";
            }
            case WEEK: {
                return "(extract(day from ?3-?2)/7)";
            }
            case DAY: {
                return "extract(day from ?3-?2)";
            }
            case NANOSECOND: 
            case NATIVE: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                return "extract(epoch from ?3-?2)" + TemporalUnit.EPOCH.conversionFactor(unit, this);
            }
        }
        throw new SemanticException("Unrecognized field: " + unit);
    }

    @Deprecated
    protected void extractField(StringBuilder pattern, TemporalUnit unit, TemporalType fromTimestamp, TemporalType toTimestamp, TemporalUnit toUnit) {
        pattern.append("extract(");
        pattern.append(this.translateDurationField(unit));
        pattern.append(" from ");
        if (toTimestamp == TemporalType.DATE && fromTimestamp == TemporalType.DATE) {
            pattern.append("age(?3,?2)");
        } else {
            switch (unit) {
                case QUARTER: 
                case YEAR: 
                case MONTH: {
                    pattern.append("age(?3,?2)");
                    break;
                }
                case DAY: 
                case HOUR: 
                case MINUTE: 
                case SECOND: 
                case EPOCH: {
                    pattern.append("?3-?2");
                    break;
                }
                default: {
                    throw new SemanticException(unit + " is not a legal field");
                }
            }
        }
        pattern.append(")").append(unit.conversionFactor(toUnit, this));
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NORMALIZE;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.cot();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.log();
        functionFactory.mod_operator();
        functionFactory.log10();
        functionFactory.tanh();
        functionFactory.sinh();
        functionFactory.cosh();
        functionFactory.moreHyperbolic();
        functionFactory.cbrt();
        functionFactory.pi();
        functionFactory.trim2();
        functionFactory.repeat();
        functionFactory.md5();
        functionFactory.initcap();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.translate();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.concat_pipeOperator("convert_from(lo_get(?1),pg_client_encoding())");
        functionFactory.localtimeLocaltimestamp();
        functionFactory.length_characterLength_pattern("length(lo_get(?1),pg_client_encoding())");
        functionFactory.bitLength_pattern("bit_length(?1)", "length(lo_get(?1))*8");
        functionFactory.octetLength_pattern("octet_length(?1)", "length(lo_get(?1))");
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.position();
        functionFactory.bitandorxornot_operator();
        functionFactory.bitAndOr();
        functionFactory.everyAny_boolAndOr();
        functionFactory.median_percentileCont(false);
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.covarPopSamp();
        functionFactory.corr();
        functionFactory.regrLinearRegressionAggregates();
        functionFactory.insert_overlay();
        functionFactory.overlay();
        functionFactory.soundex();
        functionFactory.locate_positionSubstring();
        functionFactory.windowFunctions();
        functionFactory.listagg_stringAgg("varchar");
        functionFactory.array_postgresql();
        functionFactory.arrayAggregate();
        functionFactory.arrayPosition_postgresql();
        functionFactory.arrayPositions_postgresql();
        functionFactory.arrayLength_cardinality();
        functionFactory.arrayConcat_postgresql();
        functionFactory.arrayPrepend_postgresql();
        functionFactory.arrayAppend_postgresql();
        functionFactory.arrayContains_postgresql();
        functionFactory.arrayOverlaps_postgresql();
        functionFactory.arrayGet_bracket();
        functionFactory.arraySet_unnest();
        functionFactory.arrayRemove();
        functionFactory.arrayRemoveIndex_unnest(true);
        functionFactory.arraySlice_operator();
        functionFactory.arrayReplace();
        if (this.getVersion().isSameOrAfter(14)) {
            functionFactory.arrayTrim_trim_array();
        } else {
            functionFactory.arrayTrim_unnest();
        }
        functionFactory.arrayFill_postgresql();
        functionFactory.arrayToString_postgresql();
        functionFactory.makeDateTimeTimestamp();
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates();
        if (!this.supportsMinMaxOnUuid()) {
            functionContributions.getFunctionRegistry().register("min", new PostgreSQLMinMaxFunction("min"));
            functionContributions.getFunctionRegistry().register("max", new PostgreSQLMinMaxFunction("max"));
        }
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitxor", "(?1#?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        functionContributions.getFunctionRegistry().register("round", new PostgreSQLTruncRoundFunction("round", true));
        functionContributions.getFunctionRegistry().register("trunc", new PostgreSQLTruncFunction(true, functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
        functionFactory.dateTrunc();
    }

    protected boolean supportsMinMaxOnUuid() {
        return false;
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "select current_schema()";
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsBeforeTypeName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return true;
    }

    @Override
    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "alter column " + columnName + " set data type " + columnType;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public boolean supportsValuesList() {
        return true;
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return true;
    }

    @Override
    public boolean supportsConflictClauseForInsertCTE() {
        return true;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return PostgreSQLSequenceSupport.INSTANCE;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from information_schema.sequences";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode;
        if (aliases.isEmpty()) {
            lockMode = lockOptions.getLockMode();
            for (Map.Entry<String, LockMode> entry : lockOptions.getAliasSpecificLocks()) {
                if (!entry.getValue().greaterThan(lockMode)) continue;
                aliases = entry.getKey();
            }
        }
        if ((lockMode = lockOptions.getAliasSpecificLockMode(aliases)) == null) {
            lockMode = lockOptions.getLockMode();
        }
        switch (lockMode) {
            case PESSIMISTIC_READ: {
                return this.getReadLockString(aliases, lockOptions.getTimeOut());
            }
            case PESSIMISTIC_WRITE: {
                return this.getWriteLockString(aliases, lockOptions.getTimeOut());
            }
            case UPGRADE_NOWAIT: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                return this.getForUpdateNowaitString(aliases);
            }
            case UPGRADE_SKIPLOCKED: {
                return this.getForUpdateSkipLockedString(aliases);
            }
        }
        return "";
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    @Override
    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    @Override
    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    @Override
    public String getNativeIdentifierGeneratorStrategy() {
        return "sequence";
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    @Override
    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return "cast(null as " + typeConfiguration.getDdlTypeRegistry().getDescriptor(sqlType).getRawTypeName() + ")";
    }

    @Override
    public String quoteCollation(String collation) {
        return "\"" + collation + "\"";
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    @Override
    public boolean supportsTupleCounts() {
        return true;
    }

    @Override
    public boolean supportsIsTrue() {
        return true;
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.LOWER);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteMutationStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteInsertStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new PostgreSQLSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            if (sqlState != null) {
                switch (sqlState) {
                    case "40P01": {
                        return new LockAcquisitionException(message, sqlException, sql);
                    }
                    case "55P03": {
                        return new PessimisticLockException(message, sqlException, sql);
                    }
                    case "57014": {
                        return new QueryTimeoutException(message, sqlException, sql);
                    }
                }
            }
            return null;
        };
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col++, 1111);
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    @Override
    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.POSITION;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return PostgreSQLCallableStatementSupport.INSTANCE;
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        if (position != 1) {
            throw new UnsupportedOperationException("PostgreSQL only supports REF_CURSOR parameters as the first parameter");
        }
        return (ResultSet)statement.getObject(1);
    }

    @Override
    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException("PostgreSQL only supports accessing REF_CURSOR parameters by position");
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return PostgreSQLIdentityColumnSupport.INSTANCE;
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 63;
    }

    @Override
    public boolean supportsStandardArrays() {
        return true;
    }

    @Override
    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return false;
    }

    @Override
    public boolean supportsMaterializedLobAccess() {
        return false;
    }

    @Override
    public boolean supportsTemporalLiteralOffset() {
        return true;
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(this.datetimeFormat(format).result());
    }

    public Replacer datetimeFormat(String format) {
        return OracleDialect.datetimeFormat(format, true, false).replace("SSSSSS", "US").replace("SSSSS", "US").replace("SSSS", "US").replace("SSS", "MS").replace("SS", "MS").replace("S", "MS").replace("ee", "ID").replace("e", "fmID").replace("zzz", "TZ").replace("zz", "TZ").replace("z", "TZ").replace("xxx", "OF").replace("xx", "OF").replace("x", "OF");
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "doy";
            }
            case DAY_OF_WEEK: {
                return "dow";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public AggregateSupport getAggregateSupport() {
        return PostgreSQLAggregateSupport.valueOf(this);
    }

    @Override
    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("bytea '\\x");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime(appender, temporalAccessor, true, jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime(appender, temporalAccessor);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("timestamp with time zone '");
                    DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, true, jdbcTimeZone);
                    appender.appendSql('\'');
                    break;
                }
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, false, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time with time zone '");
                DateTimeUtils.appendAsTime(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time with time zone '");
                DateTimeUtils.appendAsTime(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private String withTimeout(String lockString, int timeout) {
        switch (timeout) {
            case 0: {
                return this.supportsNoWait() ? lockString + " nowait" : lockString;
            }
            case -2: {
                return this.supportsSkipLocked() ? lockString + " skip locked" : lockString;
            }
        }
        return lockString;
    }

    @Override
    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    @Override
    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    @Override
    public String getReadLockString(int timeout) {
        return this.withTimeout(" for share", timeout);
    }

    @Override
    public String getReadLockString(String aliases, int timeout) {
        return this.withTimeout(" for share of " + aliases, timeout);
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.supportsNoWait() ? " for update nowait" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.supportsNoWait() ? " for update of " + aliases + " nowait" : this.getForUpdateString(aliases);
    }

    @Override
    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? " for update skip locked" : this.getForUpdateString();
    }

    @Override
    public String getForUpdateSkipLockedString(String aliases) {
        return this.supportsSkipLocked() ? " for update of " + aliases + " skip locked" : this.getForUpdateString(aliases);
    }

    @Override
    public boolean supportsNoWait() {
        return true;
    }

    @Override
    public boolean supportsWait() {
        return false;
    }

    @Override
    public boolean supportsSkipLocked() {
        return true;
    }

    @Override
    public boolean supportsInsertReturning() {
        return true;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return true;
    }

    @Override
    public boolean supportsFetchClause(FetchClauseType type) {
        switch (type) {
            case ROWS_ONLY: {
                return true;
            }
            case PERCENT_ONLY: 
            case PERCENT_WITH_TIES: {
                return false;
            }
            case ROWS_WITH_TIES: {
                return this.getVersion().isSameOrAfter(13);
            }
        }
        return false;
    }

    @Override
    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_REFERENCE;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.TABLE;
    }

    @Override
    public void augmentRecognizedTableTypes(List<String> tableTypesList) {
        super.augmentRecognizedTableTypes(tableTypesList);
        tableTypesList.add("MATERIALIZED VIEW");
        tableTypesList.add("PARTITIONED TABLE");
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        this.contributePostgreSQLTypes(typeContributions, serviceRegistry);
    }

    protected void contributePostgreSQLTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(2004, BlobJdbcType.BLOB_BINDING);
        jdbcTypeRegistry.addDescriptor(2005, ClobJdbcType.CLOB_BINDING);
        jdbcTypeRegistry.addDescriptor(XmlJdbcType.INSTANCE);
        if (this.driverKind == PostgreSQLDriverKind.PG_JDBC) {
            if (PgJdbcHelper.isUsable(serviceRegistry)) {
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getInetJdbcType(serviceRegistry));
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getIntervalJdbcType(serviceRegistry));
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getStructJdbcType(serviceRegistry));
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getJsonbJdbcType(serviceRegistry));
            } else {
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingInetJdbcType.INSTANCE);
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingIntervalSecondJdbcType.INSTANCE);
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLStructCastingJdbcType.INSTANCE);
                jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingJsonJdbcType.JSONB_INSTANCE);
            }
        } else {
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingInetJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingIntervalSecondJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLStructCastingJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent(PostgreSQLCastingJsonJdbcType.JSONB_INSTANCE);
        }
        typeContributions.contributeJdbcType(ObjectNullAsBinaryTypeJdbcType.INSTANCE);
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
        jdbcTypeRegistry.addDescriptor(PostgreSQLEnumJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(PostgreSQLOrdinalEnumJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(PostgreSQLUUIDJdbcType.INSTANCE);
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public boolean canBatchTruncate() {
        return true;
    }

    @Override
    public String rowId(String rowId) {
        return "ctid";
    }

    @Override
    public int rowIdSqlType() {
        return 1111;
    }

    @Override
    public String getQueryHintString(String sql, String hints) {
        return "/*+ " + hints + " */ " + sql;
    }

    @Override
    public String addSqlHintOrComment(String sql, QueryOptions queryOptions, boolean commentsEnabled) {
        if (commentsEnabled && queryOptions.getComment() != null) {
            sql = this.prependComment(sql, queryOptions.getComment());
        }
        if (queryOptions.getDatabaseHints() != null && queryOptions.getDatabaseHints().size() > 0) {
            sql = this.getQueryHintString(sql, queryOptions.getDatabaseHints());
        }
        return sql;
    }

    @Override
    public MutationOperation createOptionalTableUpdateOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        return this.optionalTableUpdateStrategy.buildMutationOperation(mutationTarget, optionalTableUpdate, factory);
    }

    private static MutationOperation usingMerge(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        PostgreSQLSqlAstTranslator translator = new PostgreSQLSqlAstTranslator(factory, optionalTableUpdate);
        return translator.createMergeOperation(optionalTableUpdate);
    }

    private static MutationOperation withoutMerge(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        return new OptionalTableUpdateOperation(mutationTarget, optionalTableUpdate, factory);
    }

    @Override
    public ParameterMarkerStrategy getNativeParameterMarkerStrategy() {
        return this.parameterRenderer;
    }

    @Override
    public int getDefaultIntervalSecondScale() {
        return 6;
    }

    @Override
    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    @Override
    public boolean supportsFromClauseInUpdate() {
        return true;
    }

    private static class NativeParameterMarkers
    implements ParameterMarkerStrategy {
        public static final NativeParameterMarkers INSTANCE = new NativeParameterMarkers();

        private NativeParameterMarkers() {
        }

        @Override
        public String createMarker(int position, JdbcType jdbcType) {
            return "$" + position;
        }
    }

    @FunctionalInterface
    private static interface OptionalTableUpdateStrategy {
        public MutationOperation buildMutationOperation(EntityMutationTarget var1, OptionalTableUpdate var2, SessionFactoryImplementor var3);
    }
}

