package com.smartgwt.sample.showcase.client.reifyIntegration;

import com.smartgwt.client.bean.BeanFactory;
import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.viewer.DetailViewer;

@BeanFactory.Generate
public class MyCustomListGrid extends ListGrid {
    
    public MyCustomListGrid() {
        setAutoFetchData(true);
        setDataSource(DataSource.get("supplyItem"));
        setCanHover(true);  
        setShowHover(true);  
        setShowHoverComponents(true);
    }

    @Override
    protected void onInit() {
        super.onInit();
        setCanRemoveRecords(false);
        ListGridField itemNameField = new ListGridField("itemName", "Item", 250);
        ListGridField descriptionField = new ListGridField("description");
        descriptionField.setWidth("*");
        ListGridField categroyField = new ListGridField("category", 250);
        ListGridField unitCostField = new ListGridField("unitCost", 100);
        unitCostField.setType(ListGridFieldType.FLOAT);
       
        ListGridField iconField = new ListGridField("iconField", "View", 100);  
        iconField.setAlign(Alignment.CENTER);  
        iconField.setType(ListGridFieldType.ICON);  
        iconField.setIconSize(24);  
        iconField.setIcon("[SKIN]/actions/view.png");
        iconField.setCanReorder(false);
        setFields(itemNameField, descriptionField, categroyField, unitCostField, iconField);
    }
        
    @Override  
    protected Canvas getCellHoverComponent(Record record, Integer rowNum, Integer colNum) {  
        String fieldName = this.getFieldName(colNum);  
        if (fieldName.equals("iconField")) {
            DetailViewer detailViewer = new DetailViewer();  
            detailViewer.setWidth(200);  
            detailViewer.setDataSource(DataSource.get("supplyItem"));  
            Criteria criteria = new Criteria();  
            criteria.addCriteria("itemID", record.getAttribute("itemID"));  
            DSRequest req = new DSRequest();  
            req.setShowPrompt(false);  
            detailViewer.fetchData(criteria, null, req);  
            return detailViewer;
       } else return null;
    }
    
}