/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */

package com.smartgwt.sample.showcase.client.shuttles;

import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.types.Overflow;
import com.smartgwt.client.types.TopOperatorAppearance;
import com.smartgwt.client.types.Visibility;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.FilterBuilder;
import com.smartgwt.client.widgets.form.SearchForm;
import com.smartgwt.client.widgets.form.fields.SelectItem;
import com.smartgwt.client.widgets.form.fields.TextItem;
import com.smartgwt.client.widgets.form.fields.SetFilterItem;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class SetFilteringSample extends ShowcasePanel {
    private static final String DESCRIPTION = 
        "This example demonstrates using the SetFilterItem and MultiPickerItem to generate "+
        "in-set and not-in-set criteria for a dataSource field."+
        "<p>"+
        "The sample shows a SearchForm by default allowing users to enter criteria to apply "+
        "to the ListGrid."+
        "<p>"+
        "The Category field has a foreignKey relationship set up with another dataSource - "+
        "effectively this is a many-to-one relationship where many Supply Items belong to each "+
        "category. The default editor for this field is a SetFilterItem which allows users to "+
        "create In-Set or Not-In-Set criteria for the field with an intuitive interface making "+
        "it easy to see entries in a specific set of categories."+
        "<p>"+
        "Click the \"Toggle Filtering Interface\" button to switch to a FilterBuilder, and select "+
        "the \"Category\" field to add a new filter clause. In this interface, the user may choose "+
        "the appropriate operator for the field criterion. Choose \"is one of\" or \"is not one of\" "+
        "to generate In-Set or Not-In-Set criterion. In this case the value-item for the criterion "+
        "will show a MultiPickerItem - a similar interface to the SetFilterItem allowing the user "+
        "to explicitly choose the set of categories to include in the criterion.";
        
    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            SetFilteringSample panel = new SetFilteringSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    public Canvas getViewPanel() {
        DataSource ds = DataSource.get("supplyItem");
        ListGrid supplyList = new ListGrid();
    	
        VLayout mainLayout = new VLayout();
        mainLayout.setMembersMargin(20);
        mainLayout.setWidth100();
        mainLayout.setHeight100();
        mainLayout.setOverflow(Overflow.AUTO);
    	
        SearchForm searchForm = new SearchForm();
        searchForm.setIsGroup(true);
        searchForm.setGroupTitle("Search Form");
        searchForm.setDataSource(ds);
    	
        TextItem skuItem = new TextItem("SKU");
        TextItem itemNameItem = new TextItem("itemName");
        SetFilterItem categoryItem = new SetFilterItem("category");
        SelectItem unitsItem = new SelectItem("units");
        searchForm.setFields(skuItem,itemNameItem,categoryItem,unitsItem);
    	
        FilterBuilder filterBuilder = new FilterBuilder();
        filterBuilder.setIsGroup(true);
        filterBuilder.setGroupTitle("Filter Builder");
        filterBuilder.setDataSource(ds);
        filterBuilder.setAllowedFields("SKU","itemName","category","units");
        filterBuilder.setTopOperatorAppearance(TopOperatorAppearance.NONE);
        filterBuilder.setVisibility(Visibility.HIDDEN);
    	
        HLayout hLayout = new HLayout();
        hLayout.setHeight(1);
        hLayout.setMembersMargin(5);
    	
        Button button = new Button();
        button.setTitle("Toggle Filtering Interface");
        button.setWidth(200);
        button.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                if (searchForm.isVisible()) {
                    searchForm.hide();
                    filterBuilder.show();
                } else {
                    searchForm.show();
                    filterBuilder.hide();
                }
                supplyList.setData();
            }
        });
    	
        Button filterGridButton = new Button();
        filterGridButton.setTitle("Filter Grid");
        filterGridButton.setWidth(200);
        filterGridButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                Criteria criteria = (searchForm.isVisible()?searchForm.getValuesAsCriteria():filterBuilder.getCriteria());
                supplyList.filterData(criteria);
            }
        });
    	
        hLayout.setMembers(button, filterGridButton);
    	
        supplyList.setWidth(500);
        supplyList.setHeight(300);
        supplyList.setDataSource(ds);
        ListGridField skuField = new ListGridField("SKU");
        ListGridField itemNameField = new ListGridField("itemName");
        ListGridField categoryField = new ListGridField("category");
        ListGridField unitsField = new ListGridField("units");
        supplyList.setFields(skuField,itemNameField,categoryField,unitsField);
    	
        mainLayout.setMembers(searchForm,filterBuilder,hLayout,supplyList);
        
        return mainLayout;
    }

    public String getIntro() {
        return DESCRIPTION;
    }
    
    @Override
    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[]{
            new SourceEntity("supplyCategory.ds.xml", XML, "source/supplyCategory.ds.xml.html", true)
        };
    }

}
