<#macro requestbodydef operation pathIncludesKey=false>
        content:
          application/json:
            schema:
              type: object
              properties:
              <#list operation.parameters as field>
                <#-- exclude primaryKey when it's also already required on the path -->
                <#if pathIncludesKey && field.primaryKey??>
                  <#continue />
                </#if>
                ${field.name}:
                  <@describe indentation=18 field=field operation=operation/>
                  <@fielddef indentation=18 field=field />
              </#list>
            example:
              {
              <#list operation.parameters as field>
                <#if pathIncludesKey && field.primaryKey??>
                   <#continue />
                </#if>
                ${field.name}: "${field.sample}"<#sep>,</#sep>
              </#list>
              }
          application/xml:
            schema:
              type: object
              xml:
                name: request
              required:
                - data
              properties:
                data:
                  type: object
                  properties:
                  <#list operation.parameters as field>
                    <#if pathIncludesKey && field.primaryKey??>
                       <#continue />
                    </#if>
                    ${field.name}:
                      <@describe indentation=22 field=field operation=operation/>
                      <@fielddef indentation=22 field=field />
                  </#list>
            example: |
              <data>
              <#list operation.parameters as field>
                <#if pathIncludesKey && field.primaryKey??>
                   <#continue />
                </#if>
                <${field.name}>${field.sample}</${field.name}>
              </#list>
              </data>
</#macro>

<#macro fielddef indentation, field>
  <#if field.type??>
    <@indent indentation, "type: ${field.type}" />
  </#if>
  <#if field.format??>
    <@indent indentation, "format: ${field.format}" />
  </#if>
  <#if field.nullable??>
    <@indent indentation, "nullable: ${field.nullable?c}" />
  </#if>
  <#if field.maximum??>
    <@indent indentation, "maximum: ${field.maximum}" />
  </#if>
  <#if field.exclusiveMaximum??>
    <@indent indentation, "exclusiveMaximum: ${field.exclusiveMaximum}" />
  </#if>
  <#if field.minimum??>
    <@indent indentation, "minimum: ${field.minimum}" />
  </#if>
  <#if field.exclusiveMinimum??>
    <@indent indentation, "exclusiveMinimum: ${field.exclusiveMinimum}" />
  </#if>
  <#if field.maxLength??>
    <@indent indentation, "maxLength: ${field.maxLength}" />
  </#if>
  <#if field.minLength??>
    <@indent indentation, "minLength: ${field.minLength}" />
  </#if>
  <#if field.pattern??>
    <@indent indentation, "pattern: ${field.pattern}" />
  </#if>
  <#if field.enum??>
    <@indent indentation, "enum:" />
    <#list field.enum as id>
      <@indent indentation+2, "- '${id}'" />
    </#list>
  </#if>
  <#if field.validators??>
    <@indent indentation, "x-validators:" />
    <#list field.validators as v>
      <@indent indentation+2, "validator-${v?counter}: " />
      <@printValidator indentation+4, v />
    </#list>
  </#if>
</#macro>

<#macro printValidator spaces, map>
  <#list map as key, val>
    <#if val?is_hash>
      <@indent spaces, "${key}:" />
      <@printValidator spaces+2, val />
      <#continue />
    </#if>
    <#-- skip it here, we'll add to the field's description -->
    <#if key == "description">
      <#continue />
    </#if>
    <#-- sigh -->
    <#if val?is_boolean>
      <@indent spaces, "${key}: ${val?c}" />
    <#else>
      <@indent spaces, "${key}: ${val}" />
    </#if>
  </#list>
</#macro>

<#macro indent spaces, content>
  <#local len = content?length >
${content?left_pad(spaces+len)}
</#macro>

<#function isRequired field, operation>
  <#if operation.required??>
    <#return operation.required?seq_contains(field.name)>
  </#if>
  <#return false>
</#function>

<#macro describe indentation, field, operation, context="request">
  <@indent indentation, "description: | " />
  <#if ((context == "response" && field.restrictions?seq_contains("view"))
     || (context == "request" && field.restrictions?seq_contains(operation.operationType)))>
    <@indent indentation+2, "**Note that access may be restricted, based on conditions evaluated at runtime.  If appropriate, contact support for details on these constraints.**  " />
  </#if>
  <#if context == "request" && isRequired(field, operation)>
    <@indent indentation+2, "**Required.**  " />
  </#if>
  <#if field.primaryKey??>
    <@indent indentation+2, "*Primary Key field*" />
  </#if>
  <#if field.fk??>
    <#local fk = field.fk />
    <@indent indentation+2, "*Foreign Key referencing '${fk.ds}.${fk.field}'*" />
  </#if>
  <#if field.description??>
    <#list field.description as line>
      <@indent indentation+2, "${line?trim}\n" />
    </#list>
  </#if>
  <#if context == "request" && field.validators?? && (operation.operationType == "add" || operation.operationType == "update")>
    <@indent indentation+2, "Validation Requirements:" />
    <#list field.validators as v>
      <#if v.description??><@indent indentation+4, "- ${v.description}" /></#if>
    </#list>
  </#if>
  <#if field.valueMap??>
    <@indent indentation+2, "Note that legal values can be mapped to the following descriptions:" />
    <#list field.valueMap as id, val>
        <@indent indentation+2, "- **${id}**: ${val}" />
    </#list>
  </#if>
</#macro>