/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2026-02-02/LGPL Deployment (2026-02-02)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//>	@object	isA
//
//	A library of functions for determining the types of other objects.<br><br>
//
//  The "isA" methods for the basic JavaScript types are much faster and more consistent across
//  platforms than JavaScript's "typeof" operator.<br><br>
//
//  An isA method is automatically created for every ISC Class and Interface definition, for
//  example, isA.Canvas().<br><br>
//
//	@example	<code>if (isA.Number(myVariable)) ...</code>
//
//	Note: <code>is</code> and <code>isAn</code> are synonyms of <code>isA</code> and can be used
//			interchangably when it looks better syntactically, eg:
//				<code>if (myObject == null) ...</code>
//			or
//				<code>if (isAn.Array(myObject)) ...</code>
// <P>
// <h4>Global Configuration Flags</h4>
// <P>
// <b><code>window.isc_crossFrameCompat</code></b>
// <P>
// By default, the isA functions use fast <code>typeof</code> checks that work correctly for
// primitive values passed between frames. However, <i>boxed primitives</i> created in another
// frame are not detected:
// <pre>
//    // Boxed primitive created in an iframe
//    var iframe = document.createElement("iframe");
//    document.body.appendChild(iframe);
//    var boxedString = new iframe.contentWindow.String("hello");
//
//    typeof boxedString;           // "object" - not "string"!
//    boxedString instanceof String; // false - different constructor
//    isc.isA.String(boxedString);   // false - cannot detect by default
// </pre>
// This edge case is extremely rare because boxed primitives are almost never used in practice.
// Normal usage such as string literals (<code>"hello"</code>), concatenation
// (<code>"a" + "b"</code>), or any standard string/number/boolean operations produce primitive
// values, not boxed objects. Only explicit constructor calls like <code>new String()</code>,
// <code>new Number()</code>, or <code>new Boolean()</code> produce boxed primitives - and these
// are widely considered a JavaScript antipattern. Primitive values passed cross-frame work
// correctly with the default isA functions.
// <P>
// For applications that need cross-frame boxed primitive detection, set
// <code>window.isc_crossFrameCompat = true</code> before loading SmartClient. This installs
// slower versions that use <code>Object.prototype.toString.call()</code>. These versions are
// also always available as <code>isc.isA.crossFrame.String()</code>,
// <code>isc.isA.crossFrame.Number()</code>, and <code>isc.isA.crossFrame.Boolean()</code>.
// <P>
// <b><code>window.isc_legacyGWT</code></b>
// <P>
// GWT versions prior to 2.5 (released 2012) had a bug where Java String objects passed to
// JavaScript would have a <code>.Class</code> property set to "String" but would not be
// detected as strings by <code>typeof</code>. Set <code>window.isc_legacyGWT = true</code>
// before loading SmartClient if using GWT versions older than 2.5.
//
// @treeLocation Client Reference/System
// @visibility external
//<
// create the "isA", "isAn" and "is" objects
isc.addGlobal("isA", {});
isc.addGlobal("isAn", isc.isA);
isc.addGlobal("is", isc.isA);

  //>DEBUG
// give it a class name so that methods added to it get labelled
isc.isA.Class = "isA";
  //<DEBUG 

isc.isA.isc = isc.isA; // so you can do isc.isA.isc.Canvas(object)


Function.__nativeType = 1;
Array.__nativeType = 2;
Date.__nativeType = 3;
String.__nativeType = 4;
Number.__nativeType = 5;
Boolean.__nativeType = 6;
RegExp.__nativeType = 7;
Object.__nativeType = 8;



Function.prototype.__nativeType = 1;




// See isA class docs for flag documentation
isc._legacyGWTWorkaround = window.isc_legacyGWT;
isc._crossFrameCompat = window.isc_crossFrameCompat;

// add methods to determine the type of various simple objects
isc.addMethods(isc.isA, {

	//> @staticMethod isA.emptyString()
	//
	//	Is <code>object</code> the empty string?<br><br>
	//	
	//	NOTE: if you prefer, you can call this as <code>isAn.emptyString()</code>
	//
	//	@param	object	(Object)	object to test
	//	@return			(boolean)	true == <code>object</code> is a null string
	//	@visibility external
	//<
	emptyString : function (object) {return isc.isA.String(object) && object == isc.emptyString},

	
	//> @staticMethod isA.nonemptyString()
	//
	//	Is <code>object</code> a non-empty String?<br><br>
	//	
	//	@param	object	(Object)	object to test
	//	@return			(boolean)	true == <code>object</code> is a non-empty string
	//	@visibility external
	//<
	nonemptyString : function (object) {return isc.isA.String(object) && object != isc.emptyString},

	
	//> @staticMethod isA.Object()
	// Returns whether the passed value is a non-<code>null</code> Object.
    // <p>
    // Returns <code>false</code> for values that are numbers, strings, booleans, functions or
    // are <code>null</code> or <code>undefined</code>.  (Note: Returns <code>true</code> for
    // the wrapper types, e.g. <code>new String("some string")</code>.)
    // <p>
    // Returns true for Object, Array, Regular Expression, Date and other kinds of
    // native objects which are considered to extend from window.Object.
	//
	// @param object (Any) value to test for whether it's an object
	// @return (boolean) whether passed value is an Object
	// @visibility external
	//<
    //  With the exception of returning false for the null value, this function's return value 
    //  matches the ECMA spec for the typeof operator.  It also seems to be a reasonable expected 
    //  implementation of this method as it guarantees the programmer can work with properties of 
    //  the object as with a standard Object returned by "new Object()".
    _$object:"object",
    _$String :"String",
	Object : function (object) {
        if (object == null) return false;

        // GWT workaround for Issue 4301, fixed in GWT 2.5. Only applied if isc_legacyGWT is set.
        if (isc._legacyGWTWorkaround &&
            object.Class != null && object.Class == this._$String)
        {
            return false;
        }

        // typeof reliably returns "object" for all objects (including RegExp, Date, Array)
        // and "function" for functions in all modern browsers
        return typeof object == "object";
    },
    
	//> @staticMethod isA.emptyObject()
	//
	// Is <code>object</code> an object with no properties (i.e.: <code>{}</code>)?
    // <P>
    // Note that an object that has properties with null values is considered non-empty, eg 
    // <code>{ propName:null }</code> is non-empty.
    // <P>
	// NOTE: if you prefer, you can call this as <code>isAn.emptyObject()</code>
	//
	//	@param	object	(Object)	object to test
	//	@return			(boolean)	true == <code>object</code> is the empty object
	//	@visibility external
	//<
    emptyObject : function (object) {
        if (!isc.isAn.Object(object)) return false;
        for (var i in object) {
            // if we have a single property we're non-empty!
            return false;
        }
        return true;
    },
    
	//> @staticMethod isA.emptyArray()
	//
	// Is <code>object</code> an Array with no items?
    //
	//	@param	object	(Object)	object to test
	//	@return			(boolean)	true == <code>object</code> is an empty array
	//	@visibility external
	//<
    emptyArray : function (object) {
        return isc.isAn.Array(object) && object.length == 0;
    },

    //> @staticMethod isA.nonemptyArray()
    // Is <code>object</code> an array with at least one item?
    // <p>
    // Note: <code>null</code>, <code>undefined</code>, and empty slots in an array are still
    // considered an item.
    //
    // @param object (Any) The object or value to test.
    // @return (boolean) <code>true</code> if <code>object</code> is an array with at least
    // one item; <code>false</code> otherwise (i.e. <code>object</code> isn't an array, or
    // it has no items)
    // @visibility external
    //<
    nonemptyArray : function (object) {
        return this.Array(object) && object.length >= 1;
    },

	//> @staticMethod isA.String()
	//
	//	Is <code>object</code> a String object?
	//
	//	@param	object	(Object)	object to test
	//	@return			(boolean)	true == <code>object</code> is a String
	//	@visibility external
	//<
    // ==========================================================================================
    // IMPORTANT: If you update this function, also update its copy in FileLoader.js
    // ==========================================================================================
	String : function (object) {
        if (object == null) return false;

        // GWT workaround for Issue 4301, fixed in GWT 2.5. Only applied if isc_legacyGWT is set.
        if (isc._legacyGWTWorkaround &&
            object.Class != null && object.Class == this._$String)
        {
            return true;
        }

        // typeof is the fastest check and works for all primitive strings and same-frame
        // String objects. Cross-frame boxed primitives (new otherFrame.String()) return
        // "object" for typeof - use isc.isA.crossFrame.String() for that rare case.
        return typeof object == "string";
	},

	//> @staticMethod isA.Array()
	//
	//	Is <code>object</code> an Array object?<br><br>
	//
	//	NOTE: if you prefer, you can call this as <code>isAn.Array()</code>
	//
	//	@param	object	(Object)	object to test
	//	@return			(boolean)	true == <code>object</code> is an Array
	//	@visibility external
	//<
	Array : function (object) {
        if (object == null) return false;

        
        return Array.isArray(object);
	},

	//> @staticMethod isA.Function()
	//
	//	Is <code>object</code> a Function object?
	//
	//	@param	object	(Object)	object to test
	//	@return			(boolean)	true == <code>object</code> is a Function
	//	@visibility external
	//<
    _$function : "function",
	Function : function (object) {
        if (object == null) return false;

        
        return typeof object == this._$function;
    },

	//> @staticMethod isA.Number()
	//
	//	Is <code>object</code> a Number object?<br><br>
	//
	//	NOTE: this returns false if <code>object</code> is an invalid number (<code>isNaN(object) == true</code>)
	//
	//	@param	object	(Object)	object to test
	//	@return			(boolean)	true == <code>object</code> is a Number
	//	@visibility external
	//<
	Number : function (object) {
        // typeof + finite check. This is equivalent to Number.isFinite(object) but slightly
        // faster because we avoid the function call overhead. Cross-frame boxed primitives
        // (new otherFrame.Number()) return "object" - use isc.isA.crossFrame.Number() for that.
        return typeof object == "number" &&
            !isNaN(object) &&
            object != Number.POSITIVE_INFINITY &&
            object != Number.NEGATIVE_INFINITY;
    },

	SpecialNumber : function (object) {
        // NOTE: we do need to first determine if it's a number because isNaN({}) is true
        if (typeof object != "number") return false;
        return isNaN(object) ||
            object == Number.POSITIVE_INFINITY ||
            object == Number.NEGATIVE_INFINITY;
    },

	//> @staticMethod isA.Boolean()
	//
	//	Is <code>object</code> a Boolean object?
	//
	//	@param	object	(Object)	object to test
	//	@return			(boolean)	true == <code>object</code> is a Boolean
	//	@visibility external
	//<
	Boolean	: function (object) {
        // typeof is the fastest check. Cross-frame boxed primitives (new otherFrame.Boolean())
        // return "object" - use isc.isA.crossFrame.Boolean() for that rare case.
        return typeof object == "boolean";
    },
	
	//> @staticMethod isA.Date()
	//
	// Is <code>object</code> a Date object?
	// <P>
	// This method should be used instead of <code>instanceof Date</code> when the object may
	// have been created in a different frame (e.g., iframe or popup window), as
	// <code>instanceof</code> fails cross-frame. This method includes fallback detection
	// using constructor toString comparison.
	//
	//	@param	object	(Object)	object to test
	//	@return			(boolean)	true == <code>object</code> is a Date
	//	@visibility external
	//<
	Date : function (object, validate) {
        if (object == null) return false;

        // Fast rejection of primitives - Dates are always objects
        if (typeof object != "object") return false;

        // instanceof handles same-frame Dates efficiently
        if (object instanceof Date) {
            // Validation for pseudo-dates from bad string parsing
            if (validate && !isc.isA.Number(object.getDate())) return false;
            return true;
        }

        // Cross-frame detection: instanceof fails because constructors differ, but
        // constructor.toString() matches. SGWT: avoid crash on Java objects.
        if (isc.Browser.isSGWT && window.SmartGWT.isNativeJavaObject(object)) return false;

        if (("" + object.constructor) == ("" + Date)) {
            // Cache the type for future checks on objects from this frame
            object.constructor.__nativeType = 3;
            if (validate && !isc.isA.Number(object.getDate())) return false;
            return true;
        }
        return false;
    },
    
	//> @staticMethod isA.RegularExpression()
	//
	// Is <code>object</code> a Regular Expression (RegExp) object?
	// <P>
	// This method should be used instead of <code>instanceof RegExp</code> when the object may
	// have been created in a different frame (e.g., iframe or popup window), as
	// <code>instanceof</code> fails cross-frame. This method includes fallback detection
	// using constructor toString comparison.
	//
	//	@param	object	(Object)	object to test
	//	@return			(boolean)	true == <code>object</code> is a RegExp
	//	@visibility external
	//<
	RegularExpression : function (object) {
        if (object == null) return false;

        // Fast rejection of primitives - RegExps are always objects
        if (typeof object != "object") return false;

        // instanceof handles same-frame RegExps efficiently
        if (object instanceof RegExp) return true;

        // Cross-frame detection: instanceof fails because constructors differ, but
        // constructor.toString() matches. SGWT: avoid crash on Java objects.
        if (isc.Browser.isSGWT && window.SmartGWT.isNativeJavaObject(object)) return false;

        if (("" + object.constructor) == ("" + RegExp)) {
            // Cache the type for future checks on objects from this frame
            object.constructor.__nativeType = 7;
            return true;
        }
        return false;
    },

    
    _$textXML : "text/xml",
    XMLNode : function (object) {
        if (object == null) return false;
        if (isc.Browser.isIE) {
            return object.specified != null && object.parsed != null && 
                   object.nodeType != null && object.hasChildNodes != null;
        }
        var doc = object.ownerDocument;
        if (doc == null) return false;
        return doc.contentType == this._$textXML;
    },
	

	// ---------------------------------------------------------------------------------------
    // NOTE: the following few functions are used strictly in expressionToFunction(), are not
    // i18n-safe, and should not be externally visible
	// ---------------------------------------------------------------------------------------

 	//> @staticMethod isA.AlphaChar() 
 	// 
 	//  Is the character passed in an alpha character? 
 	// 
 	//  @param  char    (String)        character to test 
 	//  @return                 (boolean)       true == character is alpha 
 	//< 
 	AlphaChar : function (character) { 
 		// XXX: does not yet deal with unicode characters or extended ASCII characters. 
 		var code = character.charCodeAt(0);
 		return ((code >= 65 && 
 				 code <= 90) || 
 				(code >= 97 && 
 				 code <= 122)) 
 	}, 
 	
 	//> @staticMethod isA.NumChar() 
 	// 
 	//  Is the character passed in a Decimal (0-9) character? 
 	// 
 	//  @param  char    (String)        character to test 
 	//  @return                 (boolean)       true == character is a decimal character 
 	//< 
 	NumChar : function (character) { 
 		// XXX: does not yet deal with unicode characters 
 		var code = character.charCodeAt(0) 
 		return (code >= 48 && 
 				code <= 57) 
 	}, 
 	
 	//> @staticMethod isA.AlphaNumericChar() 
 	// 
 	//  Is the character passed in alphanumeric? 
 	// 
 	//  @param  char    (String)        character to test 
 	//  @return                 (boolean)       true == character is alphanumeric 
 	//< 
 	AlphaNumericChar : function (character) { 
        return (isc.isA.AlphaChar(character) || isc.isA.NumChar(character)) 
    }, 
 	
 	//> @staticMethod isA.WhitespaceChar() 
 	// 
 	//  Is the character passed in a whitespace character? 
 	//  This method considers any ascii character from 0-32 to be a whitespace character. 
 	// 
 	//  @param  char    (String)        character to test 
 	//  @return                 (boolean)       true == character is a whitespace character 
 	//< 
 	WhitespaceChar : function (character) { 
 		// XXX: does not yet deal with unicode characters 
 		var code = character.charCodeAt(0) 
 		return (code >= 0 && 
    			code <= 32) 
 	},
    
    //> @staticMethod isA.color
    //  Is this a valid css color.  Used by the isColor() validator
    //<
    
    color : function (object) {
        if (!isc.isA.String(object)) return false;
            
        if (!this._cssColorRegexp) {
            this._cssColorRegexp = new RegExp( 
                            // hex:         "#D3D3D3", etc 
                            "^(#([\\dA-F]{2}){3}|" +
                            "#([\\dA-F]{2}){4}|" +
                            // rgb:         "rgb(255,255,255)", etc.
                            
                                "rgb\\((\\s*[\\d]{1,3}\\s*,\\s*){2}\\s*[\\d]{1,3}\\s*\\)" +
                            // colorname:   "white", "black", "pink", etc.
                            
                                ")$", 
                                
                            // Case insensitive
                            "i"
            );
        }

        
        var result = this._cssColorRegexp.test(object);
        if (!result) {
            if (object == "transparent" || isc.ColorUtils.colorNames[object]) {
                // support 'transparent' and standard color-names
                result = true;
            }
        }
        return result;
    },

    // Module Dependencies:
    // ResultSet / ResultTree are both defined as part of the Databinding module but are frequently
    // checked for within grids.
    // Implement default isA functions for these classes so we can check isc.isA.ResultSet() without
    // needing an explicit check for the function being present
    ResultSet : function (data) {
        return false;
    },
    ResultTree : function (data) {
        return false;
    },
    
    // Overridding isA.className methods:
    // We provide custom isc.isA implementations for the following class names which we don't
    // want to be clobberred when the class method is defined
    
    _customClassIsA:{
        SelectItem:true,
        Time:true
    },
    
    // SelectItem IsA Overrides   
    // ---------------------------------------------------------------------------------------

    // isc.isA.SelectItem() default implementation would come from the definition of the
    // selectItem class.
    // However we want this method to return true for NativeSelectItems (not a subclass of
    // SelectItem).
    SelectItem : function (object) {
        if(object==null||object.isA==null||
            object.ns==null||object.ns.isA==null||object.isA===object.ns.isA){
            return false;
        }
        return object.isA("SelectItem") || object.isA("NativeSelectItem");
    },

    // Support 'isA.SelectOtherItem()' to test for SelectItems or NativeSelectItems where
    // isSelectOther is true.
    SelectOtherItem : function (item) {
        return isc.isA.SelectItem(item) && item.isSelectOther == true;
    },
    
    // SmartClient stores Times in JavaScript Date objects so make isA.Time a synonym for isA.Date
    Time : function (object) {
        return isc.isA.Date(object);
    }

});

if (Array.isArray) {
    isc.addMethods(isc.isA, {
        
        Array : Array.isArray
    });
}


// =============================================================================
// Cross-Frame Boxed Primitive Detection
// =============================================================================
// These versions use Object.prototype.toString.call() which correctly identifies boxed
// primitives from other frames. They are slower than the typeof-based versions but handle
// the rare case of cross-frame boxed primitives (new otherFrame.String("text"), etc.).
//
// Always available as isc.isA.crossFrame.String(), etc.
// Installed as default isc.isA.String() etc. if window.isc_crossFrameCompat = true.

isc.isA.crossFrame = {
    _$toString: Object.prototype.toString,
    _$objectString: "[object String]",
    _$objectNumber: "[object Number]",
    _$objectBoolean: "[object Boolean]",

    String : function (object) {
        if (object == null) return false;
        // GWT workaround for Issue 4301, fixed in GWT 2.5
        if (isc._legacyGWTWorkaround &&
            object.Class != null && object.Class == "String")
        {
            return true;
        }
        // typeof handles primitives; toString handles boxed primitives from any frame
        var type = typeof object;
        if (type == "string") return true;
        if (type != "object") return false;
        return isc.isA.crossFrame._$toString.call(object) == isc.isA.crossFrame._$objectString;
    },

    Number : function (object) {
        if (object == null) return false;
        var type = typeof object;
        if (type == "number") {
            return !isNaN(object) &&
                object != Number.POSITIVE_INFINITY &&
                object != Number.NEGATIVE_INFINITY;
        }
        if (type != "object") return false;
        // Boxed number - check via toString, then validate
        if (isc.isA.crossFrame._$toString.call(object) != isc.isA.crossFrame._$objectNumber) {
            return false;
        }
        var val = object.valueOf();
        return !isNaN(val) &&
            val != Number.POSITIVE_INFINITY &&
            val != Number.NEGATIVE_INFINITY;
    },

    Boolean : function (object) {
        if (object == null) return false;
        var type = typeof object;
        if (type == "boolean") return true;
        if (type != "object") return false;
        return isc.isA.crossFrame._$toString.call(object) == isc.isA.crossFrame._$objectBoolean;
    }
};

// If cross-frame boxed primitive detection is enabled, replace the fast versions with
// the slower cross-frame compatible versions
if (isc._crossFrameCompat) {
    isc.isA.String = isc.isA.crossFrame.String;
    isc.isA.Number = isc.isA.crossFrame.Number;
    isc.isA.Boolean = isc.isA.crossFrame.Boolean;
}


//	@end @object isA
