package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Format for encoding dates in JSON.  Note you can override {@link com.smartgwt.client.util.JSONEncoder#encodeDate
 * JSONEncoder.encodeDate()} for a custom format.
 */
public enum JSONDateFormat implements ValueEnum {
    /**
     * dates are encoded as a String in <a target=_blank href="http://www.w3.org/TR/xmlschema-2/#dateTime">XML Schema date
     * format</a> in UTC, for example, "2005-08-02" for logical date fields or "2005-08-01T21:35:48.350" for
     * <code>datetime</code> fields. See {@link com.smartgwt.client.docs.DateFormatAndStorage Date format and\n storage} for
     * more information.<br> <b>Note.</b>If JSON containing xmlSchema-formatted date values is passed to  {@link
     * com.smartgwt.client.util.JSON#decodeSafe JSON.decodeSafe()} or {@link com.smartgwt.client.util.JSON#decodeSafeWithDates
     * JSON.decodeSafeWithDates()}, these formatted date values  will not be converted to actual date objects in the generated
     * JavaScript object.  Use "logicalDateString" instead.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "xmlSchema".
     */
    XML_SCHEMA("xmlSchema"),
    /**
     * dates are encoded as raw JavaScript code for creating a Date object, that is:
     *  <pre>
     *  new Date(1238792738633)
     *  </pre>
     *  This is not strictly valid JSON, but if eval()d, will result in an identical date object,
     *  regardless of timezone. However, it does not preserve the distinction between
     *  logical dates vs full datetime values - use "logicalDateConstructor" mode for that.<br>
     *  <b>Note.</b>This format does not work with {@link com.smartgwt.client.util.JSON#decodeSafe JSON.decodeSafe()}. 
     * If you need to use {@link com.smartgwt.client.util.JSON#decodeSafe JSON.decodeSafe()} and/or {@link
     * com.smartgwt.client.util.JSON#decodeSafeWithDates JSON.decodeSafeWithDates()},
     *  you will need to use "logicalDateString" instead.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "dateConstructor".
     */
    DATE_CONSTRUCTOR("dateConstructor"),
    /**
     * serializes Date instances in a way that preserves the distinction between logical dates, logical times, and full
     * datetime values, as explained {@link com.smartgwt.client.docs.DateFormatAndStorage here}. Like 'dateConstructor' mode,
     * this does not produce strictly valid JSON, and instead embeds JavaScript calls.  <p> In addition, unlike
     * 'dateConstructor' mode, using eval() to reconstruct the original JavaScript objects will only work in the presence of
     * Smart GWT, and not just in a generic JavaScript interpreter.<br> <b>Note.</b>This format does not work with {@link
     * com.smartgwt.client.util.JSON#decodeSafe JSON.decodeSafe()}.  If you need to use {@link
     * com.smartgwt.client.util.JSON#decodeSafe JSON.decodeSafe()} and/or {@link
     * com.smartgwt.client.util.JSON#decodeSafeWithDates JSON.decodeSafeWithDates()}, you will need to use "logicalDateString"
     * instead.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "logicalDateConstructor".
     */
    LOGICAL_DATE_CONSTRUCTOR("logicalDateConstructor"),
    /**
     * Dates are encoded as strings in a format that {@link com.smartgwt.client.util.JSON#decodeSafeWithDates
     * JSON.decodeSafeWithDates()} will recognize. This allows developers to round-trip  date, time and datetime values to and
     * from strict JSON.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "logicalDateString".
     */
    LOGICAL_DATE_STRING("logicalDateString");
    private String value;

    JSONDateFormat(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
